package com.sensor.bridge;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 확장된 센서 데이터 클래스
 * 다중 센서 데이터를 처리하기 위한 모델
 */
public class ExtendedSensorData {
    // 기본 데이터
    private double temperature;
    private double humidity;
    
    // 환경 센서 데이터
    private double pm10;
    private double pm25;
    private double pressure;
    private double illumination;
    private double tvoc;
    private double co2;
    private double o2;
    private double co;
    
    // 원시 데이터 (디버깅용)
    private double rawTem;
    private double rawHum;
    private double floatValue;
    private int signedInt32Value;
    private long unsignedInt32Value;
    
    // 메타데이터
    @JsonProperty("device_id")
    private String deviceId;
    
    @JsonProperty("node_id")
    private int nodeId;
    
    private double longitude;
    private double latitude;
    
    @JsonProperty("recorded_time")
    private String recordedTime;
    
    // 기본 생성자
    public ExtendedSensorData() {}
    
    // Getters and Setters
    public double getTemperature() { return temperature; }
    public void setTemperature(double temperature) { this.temperature = temperature; }
    
    public double getHumidity() { return humidity; }
    public void setHumidity(double humidity) { this.humidity = humidity; }
    
    public double getPm10() { return pm10; }
    public void setPm10(double pm10) { this.pm10 = pm10; }
    
    public double getPm25() { return pm25; }
    public void setPm25(double pm25) { this.pm25 = pm25; }
    
    public double getPressure() { return pressure; }
    public void setPressure(double pressure) { this.pressure = pressure; }
    
    public double getIllumination() { return illumination; }
    public void setIllumination(double illumination) { this.illumination = illumination; }
    
    public double getTvoc() { return tvoc; }
    public void setTvoc(double tvoc) { this.tvoc = tvoc; }
    
    public double getCo2() { return co2; }
    public void setCo2(double co2) { this.co2 = co2; }
    
    public double getO2() { return o2; }
    public void setO2(double o2) { this.o2 = o2; }
    
    public double getCo() { return co; }
    public void setCo(double co) { this.co = co; }
    
    public double getRawTem() { return rawTem; }
    public void setRawTem(double rawTem) { this.rawTem = rawTem; }
    
    public double getRawHum() { return rawHum; }
    public void setRawHum(double rawHum) { this.rawHum = rawHum; }
    
    public double getFloatValue() { return floatValue; }
    public void setFloatValue(double floatValue) { this.floatValue = floatValue; }
    
    public int getSignedInt32Value() { return signedInt32Value; }
    public void setSignedInt32Value(int signedInt32Value) { this.signedInt32Value = signedInt32Value; }
    
    public long getUnsignedInt32Value() { return unsignedInt32Value; }
    public void setUnsignedInt32Value(long unsignedInt32Value) { this.unsignedInt32Value = unsignedInt32Value; }
    
    public String getDeviceId() { return deviceId; }
    public void setDeviceId(String deviceId) { this.deviceId = deviceId; }
    
    public int getNodeId() { return nodeId; }
    public void setNodeId(int nodeId) { this.nodeId = nodeId; }
    
    public double getLongitude() { return longitude; }
    public void setLongitude(double longitude) { this.longitude = longitude; }
    
    public double getLatitude() { return latitude; }
    public void setLatitude(double latitude) { this.latitude = latitude; }
    
    public String getRecordedTime() { return recordedTime; }
    public void setRecordedTime(String recordedTime) { this.recordedTime = recordedTime; }
    
    @Override
    public String toString() {
        return "ExtendedSensorData{" +
                "deviceId='" + deviceId + '\'' +
                ", nodeId=" + nodeId +
                ", temperature=" + temperature +
                ", humidity=" + humidity +
                ", pm10=" + pm10 +
                ", pm25=" + pm25 +
                ", pressure=" + pressure +
                ", illumination=" + illumination +
                ", tvoc=" + tvoc +
                ", co2=" + co2 +
                ", o2=" + o2 +
                ", co=" + co +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", recordedTime='" + recordedTime + '\'' +
                '}';
    }
} 