import { useRealTimeData, ConnectionStatus } from './useRealTimeData';
import { SensorData } from '../services/api';

interface UseSensorDataReturn {
  latestData: SensorData[];
  loading: boolean;
  error: string | null;
  refetch: () => Promise<void>;
  isConnected: boolean;
  connectionStatus: ConnectionStatus;
  dataSource: 'polling';
  lastUpdate: string;
  retryCount: Map<string, number>;
}

export const useSensorData = (deviceIds: string[]): UseSensorDataReturn => {
  const {
    data: latestData,
    isConnected,
    connectionStatus,
    dataSource,
    lastUpdate,
    error,
    loading,
    refetch,
    retryCount
  } = useRealTimeData(deviceIds);

  return {
    latestData,
    loading,
    error,
    refetch,
    isConnected,
    connectionStatus,
    dataSource,
    lastUpdate,
    retryCount
  };
}; 