import React, { memo } from 'react';
import { formatSensorValue, getSensorPrecision } from '../utils/formatters';
import Tooltip from './Tooltip';

interface SensorCardProps {
  title: string;
  value: number | undefined;
  unit: string;
  icon: string;
  bgColor: string;
  precision?: number;
  description?: string;
}

const SensorCard: React.FC<SensorCardProps> = memo(({
  title,
  value,
  unit,
  icon,
  bgColor,
  precision,
  description
}) => {
  const displayValue = value !== undefined 
    ? formatSensorValue(value, precision || getSensorPrecision(title.toLowerCase()))
    : 'N/A';

  const cardContent = (
    <div className="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
      <div className="flex items-center">
        <div className={`p-2 ${bgColor} rounded-lg`}>
          <span className="text-2xl">{icon}</span>
        </div>
        <div className="ml-4">
          <p className="text-sm font-medium text-gray-600 dark:text-gray-400">{title}</p>
          <p className="text-2xl font-semibold text-gray-900 dark:text-white">
            {displayValue} {unit}
          </p>
        </div>
      </div>
    </div>
  );

  return description ? (
    <Tooltip content={description} position="top">
      {cardContent}
    </Tooltip>
  ) : cardContent;
});

SensorCard.displayName = 'SensorCard';

export default SensorCard; 