package main

import (
	"log"
	"os"
	"os/signal"
	"syscall"

	"sensor-server/internal/server"
)

func main() {
	// 서버 생성
	srv := server.NewServer()

	// 서버 초기화
	if err := srv.Initialize(); err != nil {
		log.Fatalf("Failed to initialize server: %v", err)
	}

	// 서버 시작 (고루틴으로 실행)
	go func() {
		if err := srv.Run(); err != nil {
			log.Fatalf("Failed to start server: %v", err)
		}
	}()

	// 종료 신호 대기
	quit := make(chan os.Signal, 1)
	signal.Notify(quit, syscall.SIGINT, syscall.SIGTERM)
	<-quit

	log.Println("Shutting down server...")
} 