package com.sensor.bridge;

/**
 * 센서별 온도 파싱을 위한 인터페이스
 * 각 센서 타입별로 특화된 파싱 로직을 구현
 */
public interface SensorParser {
    
    /**
     * 온도 데이터 파싱
     * @param data 센서 데이터
     * @param paramItem 파라미터 정보
     * @return 파싱된 온도 값 (°C)
     */
    double parseTemperature(SensorData data, ParamItem paramItem);
    
    /**
     * 센서 데이터 유효성 검증
     * @param data 센서 데이터
     * @return 유효한 데이터인지 여부
     */
    boolean isValid(SensorData data);
    
    /**
     * 센서 타입 반환
     * @return 센서 타입
     */
    String getSensorType();
    
    /**
     * 파싱 품질 점수 반환 (0.0 ~ 1.0)
     * @param data 센서 데이터
     * @return 파싱 품질 점수
     */
    double getParsingQuality(SensorData data);
}
