package com.sensor.bridge;

/**
 * param.dat 파일의 파라미터 정보를 담는 클래스
 * 온도 파싱에 필요한 스케일 팩터, 오프셋 등을 포함
 */
public class ParamItem {
    private String sensorType;
    private String dataType;
    private double scaleFactor;
    private double offset;
    private double minValue;
    private double maxValue;
    private double defaultValue;
    private String description;
    
    public ParamItem() {
        // 기본값 설정
        this.scaleFactor = 1.0;
        this.offset = 0.0;
        this.minValue = -40.0;
        this.maxValue = 80.0;
        this.defaultValue = 25.0;
    }
    
    public ParamItem(String sensorType, String dataType, double scaleFactor, double offset) {
        this();
        this.sensorType = sensorType;
        this.dataType = dataType;
        this.scaleFactor = scaleFactor;
        this.offset = offset;
    }
    
    // Getters and Setters
    public String getSensorType() {
        return sensorType;
    }
    
    public void setSensorType(String sensorType) {
        this.sensorType = sensorType;
    }
    
    public String getDataType() {
        return dataType;
    }
    
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
    
    public double getScaleFactor() {
        return scaleFactor;
    }
    
    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }
    
    public double getOffset() {
        return offset;
    }
    
    public void setOffset(double offset) {
        this.offset = offset;
    }
    
    public double getMinValue() {
        return minValue;
    }
    
    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }
    
    public double getMaxValue() {
        return maxValue;
    }
    
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }
    
    public double getDefaultValue() {
        return defaultValue;
    }
    
    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * 온도 값의 유효성 검증
     * @param temperature 검증할 온도 값
     * @return 유효한 값인지 여부
     */
    public boolean isValidTemperature(double temperature) {
        return temperature >= minValue && temperature <= maxValue;
    }
    
    /**
     * 보정된 온도 값 계산
     * @param rawValue 원시 값
     * @return 보정된 온도 값
     */
    public double calculateCalibratedTemperature(double rawValue) {
        return rawValue * scaleFactor + offset;
    }
    
    @Override
    public String toString() {
        return String.format("ParamItem{sensorType='%s', dataType='%s', scaleFactor=%.2f, offset=%.2f, range=[%.1f, %.1f], default=%.1f}",
                           sensorType, dataType, scaleFactor, offset, minValue, maxValue, defaultValue);
    }
}
