package com.sensor.bridge;

/**
 * 센서 데이터를 담는 클래스
 * 온도 파싱에 필요한 모든 데이터 필드를 포함
 */
public class SensorData {
    private final double rawTem;
    private final double floatValue;
    private final int signedInt32Value;
    private final long unsignedInt32Value;
    
    public SensorData(double rawTem, double floatValue, int signedInt32Value, long unsignedInt32Value) {
        this.rawTem = rawTem;
        this.floatValue = floatValue;
        this.signedInt32Value = signedInt32Value;
        this.unsignedInt32Value = unsignedInt32Value;
    }
    
    // Getters
    public double getRawTem() {
        return rawTem;
    }
    
    public double getFloatValue() {
        return floatValue;
    }
    
    public int getSignedInt32Value() {
        return signedInt32Value;
    }
    
    public long getUnsignedInt32Value() {
        return unsignedInt32Value;
    }
    
    @Override
    public String toString() {
        return String.format("SensorData{rawTem=%.2f, floatValue=%.2f, signedInt32Value=%d, unsignedInt32Value=%d}", 
                           rawTem, floatValue, signedInt32Value, unsignedInt32Value);
    }
}
