# Java Spring(전자정부프레임워크) 센서 시스템 개발 가이드 - 전체 목차

## 📚 가이드 구성

현재 프로젝트를 바탕으로 Java Spring(전자정부프레임워크)으로 센서 정보를 수집하고 관리하는 웹프로그램을 개발하기 위한 완전한 가이드입니다.

---

## 📖 가이드 목차

### **Part 1: 프로젝트 개요 및 기본 설정**
- [Java_Spring_센서_시스템_개발_가이드_1.md](./Java_Spring_센서_시스템_개발_가이드_1.md)
  - 프로젝트 개요 및 시스템 아키텍처
  - 프로젝트 구조 및 개발 환경 설정
  - Maven 프로젝트 설정 (pom.xml)
  - Spring Boot 메인 클래스
  - 설정 파일 (application.yml)
  - 데이터 모델 (JPA 엔티티)

### **Part 2: 핵심 구현 및 웹 인터페이스**
- [Java_Spring_센서_시스템_개발_가이드_2.md](./Java_Spring_센서_시스템_개발_가이드_2.md)
  - DTO 클래스 및 Repository 계층
  - Service 계층 및 Controller 계층
  - 웹 인터페이스 (Thymeleaf + JavaScript)
  - 기존 시스템 연동 방법
  - Docker Compose 설정

### **Part 3: 배포, 테스트 및 운영**
- [Java_Spring_센서_시스템_개발_가이드_3.md](./Java_Spring_센서_시스템_개발_가이드_3.md)
  - 배포 및 실행 방법
  - 모니터링 및 로깅
  - 테스트 코드 작성
  - 보안 설정 및 성능 최적화
  - 문제 해결 가이드
  - 향후 개선 계획

---

## 🎯 주요 특징

### **기술 스택**
- **백엔드**: Java 11 + Spring Boot 2.7.x + 전자정부프레임워크 4.0.x
- **데이터베이스**: PostgreSQL + Redis
- **웹 프론트엔드**: Thymeleaf + Bootstrap + Chart.js
- **빌드 도구**: Maven
- **컨테이너**: Docker + Docker Compose

### **아키텍처**
- **계층형 아키텍처**: Controller → Service → Repository → Entity
- **REST API**: 센서 데이터 수집 및 조회
- **캐싱 전략**: Redis + JPA 2nd Level Cache
- **모니터링**: Spring Actuator + Micrometer

### **기존 시스템과의 차이점**
| 구분 | 기존 Go 서버 | 새로운 Spring Boot |
|------|-------------|-------------------|
| **언어** | Go | Java 11 |
| **프레임워크** | Gin | Spring Boot + 전자정부프레임워크 |
| **데이터 접근** | 직접 SQL | JPA + Hibernate |
| **웹 인터페이스** | 없음 | Thymeleaf 템플릿 |
| **보안** | 기본 | Spring Security |
| **모니터링** | 기본 | Spring Actuator |

---

## 🚀 빠른 시작

### **1. 개발 환경 준비**
```bash
# Java 11 설치 확인
java -version

# Maven 설치 확인
mvn -version

# 프로젝트 클론
git clone <repository-url>
cd docker_sensor_server
```

### **2. Spring 애플리케이션 생성**
```bash
# 새로운 Spring 프로젝트 디렉토리 생성
mkdir sensor-spring-app
cd sensor-spring-app

# 가이드의 pom.xml 복사 및 Maven 의존성 설치
mvn clean install
```

### **3. 기존 시스템과 함께 실행**
```bash
# 전체 시스템 실행 (기존 + 새로운 Spring 앱)
docker-compose up -d

# Spring 애플리케이션만 실행
docker-compose up -d sensor-spring-app
```

---

## 📋 구현 체크리스트

### **Phase 1: 기본 구조 (1-2주)**
- [ ] Spring Boot 프로젝트 생성
- [ ] 기본 엔티티 및 Repository 구현
- [ ] 간단한 REST API 구현
- [ ] 데이터베이스 연결 테스트

### **Phase 2: 핵심 기능 (2-3주)**
- [ ] 센서 데이터 수집 API 완성
- [ ] 데이터 조회 및 히스토리 API 구현
- [ ] Redis 캐싱 시스템 구축
- [ ] 기본 웹 대시보드 구현

### **Phase 3: 고도화 (3-4주)**
- [ ] 전자정부프레임워크 통합
- [ ] 보안 시스템 구축
- [ ] 모니터링 및 로깅 시스템
- [ ] 성능 최적화

### **Phase 4: 테스트 및 배포 (1-2주)**
- [ ] 단위/통합 테스트 작성
- [ ] Docker 컨테이너화
- [ ] 운영 환경 배포
- [ ] 기존 시스템과의 연동 테스트

---

## 🔗 관련 파일

### **기존 시스템 파일**
- `sensor-bridge/` - Java 센서 브리지 (RSNet SDK)
- `docker-compose.yml` - 전체 시스템 설정
- `README.md` - 기존 프로젝트 문서
- `SENSOR_MVP_인수인계서.md` - 상세 인수인계서

### **새로운 Spring 애플리케이션**
- `sensor-spring-app/` - Spring Boot 애플리케이션 (가이드에 따라 생성)
- `Java_Spring_센서_시스템_개발_가이드_*.md` - 개발 가이드 문서

---

## 💡 개발 팁

### **Spring Boot 개발**
- 프로파일을 활용한 환경별 설정 분리
- Spring Boot의 자동 설정 기능 최대한 활용
- Maven BOM을 통한 의존성 버전 관리

### **JPA 사용**
- N+1 문제 방지를 위한 fetch join, @EntityGraph 활용
- 벌크 연산을 위한 JpaRepository.saveAll() 활용
- @Transactional 범위 최소화

### **성능 최적화**
- Redis + JPA 2nd Level Cache 조합
- @Async + CompletableFuture를 활용한 비동기 처리
- 데이터베이스 인덱스, 파티셔닝, 커넥션 풀 최적화

---

## 🚨 주의사항

### **보안**
- 모든 사용자 입력에 대한 검증 필수
- JPA 사용으로 SQL 인젝션 자동 방지
- Thymeleaf의 기본 이스케이프 활용

### **성능**
- JVM 힙 메모리 모니터링 필수
- 데이터베이스 커넥션 풀 크기 적절히 설정
- 데이터 변경 시 캐시 무효화 전략 수립

### **운영**
- 로그 파일 크기 및 보관 기간 설정
- Spring Actuator + Prometheus 연동
- 데이터베이스 정기 백업 및 복구 테스트

---

## 📞 지원 및 문의

### **개발 지원**
- **기술 문서**: 각 가이드 파일 참조
- **API 문서**: Swagger UI (/swagger-ui.html)
- **모니터링**: Spring Actuator 엔드포인트 활용

### **문제 해결**
- **로그 분석**: 애플리케이션 로그 및 시스템 로그 확인
- **성능 분석**: JVM 메트릭 및 데이터베이스 쿼리 분석
- **네트워크 분석**: 포트 및 연결 상태 확인

---

## 📝 변경 이력

| 날짜 | 버전 | 변경 내용 | 작성자 |
|------|------|-----------|--------|
| 2024-12-XX | 1.0.0 | 초기 가이드 작성 완료 | AI Assistant |

---

**작성일**: 2024년 12월  
**작성자**: AI Assistant  
**버전**: 1.0.0  

---

*이 가이드는 현재 구현된 프로젝트를 바탕으로 Java Spring(전자정부프레임워크)으로 센서 정보를 수집하고 관리하는 웹프로그램을 개발하기 위한 완전한 가이드입니다.  
각 Part를 순서대로 참조하여 단계별로 개발을 진행하시기 바랍니다.*
