#!/usr/bin/env python3
"""
임계값 수정 테스트 스크립트
chamfer_distance와 emd의 새로운 정규화 로직을 테스트합니다.
"""

import sys
import os
sys.path.append(os.path.join(os.path.dirname(__file__), 'src'))

from evaluator import normalize_score_improved

def test_normalization():
    """정규화 함수 테스트"""
    
    # 테스트 케이스: 실제 계산된 값들
    test_cases = [
        {
            'metric_name': 'chamfer_distance',
            'metric_value': 0.2777,
            'threshold': 0.3,  # 새로운 임계값
            'description': 'chamfer_distance: 0.2777 (새 임계값 0.3)'
        },
        {
            'metric_name': 'emd',
            'metric_value': 0.2265,
            'threshold': 0.3,  # 새로운 임계값
            'description': 'emd: 0.2265 (새 임계값 0.3)'
        },
        {
            'metric_name': 'chamfer_distance',
            'metric_value': 0.2777,
            'threshold': 0.1,  # 기존 임계값 (비교용)
            'description': 'chamfer_distance: 0.2777 (기존 임계값 0.1)'
        },
        {
            'metric_name': 'emd',
            'metric_value': 0.2265,
            'threshold': 0.1,  # 기존 임계값 (비교용)
            'description': 'emd: 0.2265 (기존 임계값 0.1)'
        }
    ]
    
    print("=== 정규화 점수 테스트 결과 ===\n")
    
    for case in test_cases:
        score = normalize_score_improved(
            case['metric_name'], 
            case['metric_value'], 
            case['threshold']
        )
        
        ratio = case['metric_value'] / case['threshold']
        
        print(f"{case['description']}")
        print(f"  원본 값: {case['metric_value']}")
        print(f"  임계값: {case['threshold']}")
        print(f"  비율: {ratio:.3f}")
        print(f"  정규화 점수: {score:.1f}점")
        print()
    
    # 추가 테스트 케이스들
    additional_cases = [
        ('chamfer_distance', 0.15, 0.3, '임계값의 절반 (우수)'),
        ('chamfer_distance', 0.3, 0.3, '임계값과 동일 (양호)'),
        ('chamfer_distance', 0.6, 0.3, '임계값의 2배 (보통)'),
        ('chamfer_distance', 1.0, 0.3, '임계값의 3.33배 (낮음)'),
        ('emd', 0.15, 0.3, '임계값의 절반 (우수)'),
        ('emd', 0.3, 0.3, '임계값과 동일 (양호)'),
        ('emd', 0.6, 0.3, '임계값의 2배 (보통)'),
        ('emd', 1.0, 0.3, '임계값의 3.33배 (낮음)'),
    ]
    
    print("=== 추가 테스트 케이스 ===\n")
    
    for metric_name, value, threshold, description in additional_cases:
        score = normalize_score_improved(metric_name, value, threshold)
        ratio = value / threshold
        
        print(f"{description}")
        print(f"  {metric_name}: {value} (임계값: {threshold})")
        print(f"  비율: {ratio:.3f}")
        print(f"  정규화 점수: {score:.1f}점")
        print()

if __name__ == "__main__":
    test_normalization()
