import logging
from typing import Dict, Any

logger = logging.getLogger(__name__)

class NormalizationValidator:
    """정규화 결과 검증 클래스"""
    
    @staticmethod
    def validate_normalization_results(results: Dict[str, Any]) -> bool:
        """
        정규화 결과의 합리성 검증
        Args:
            results: 메트릭별 정규화 결과
        Returns:
            검증 통과 여부
        """
        warnings = []
        
        for metric, data in results.items():
            raw_value = data.get('raw_value', 0)
            normalized = data.get('normalized', 0)
            
            # 비정상적인 정규화 결과 검증
            if normalized > 90 and raw_value > 0.1:
                warnings.append(f"{metric}: 높은 원본 값({raw_value})에 높은 정규화 점수({normalized})")
            
            if normalized < 10 and raw_value < 0.01:
                warnings.append(f"{metric}: 낮은 원본 값({raw_value})에 낮은 정규화 점수({normalized})")
        
        if warnings:
            for warning in warnings:
                logger.warning(f"Normalization validation warning: {warning}")
            return False
        
        return True
