#!/usr/bin/env python3
import sys
import os
sys.path.append('src')
from evaluator import normalize_score_improved

# 테스트 케이스
print('=== 정규화 점수 테스트 결과 ===')
print()

# 실제 계산된 값들로 테스트
chamfer_old = normalize_score_improved('chamfer_distance', 0.2777, 0.1)
chamfer_new = normalize_score_improved('chamfer_distance', 0.2777, 0.3)
emd_old = normalize_score_improved('emd', 0.2265, 0.1)
emd_new = normalize_score_improved('emd', 0.2265, 0.3)

print(f'chamfer_distance: 0.2777')
print(f'  기존 임계값 0.1: {chamfer_old:.1f}점')
print(f'  새 임계값 0.3: {chamfer_new:.1f}점')
print(f'  개선: {chamfer_new - chamfer_old:+.1f}점')
print()

print(f'emd: 0.2265')
print(f'  기존 임계값 0.1: {emd_old:.1f}점')
print(f'  새 임계값 0.3: {emd_new:.1f}점')
print(f'  개선: {emd_new - emd_old:+.1f}점')
print()

# 비율 계산
print('비율 분석:')
print(f'chamfer_distance: 0.2777/0.3 = {0.2777/0.3:.3f} (새 임계값 기준)')
print(f'emd: 0.2265/0.3 = {0.2265/0.3:.3f} (새 임계값 기준)')

