# NumPy와 Pandas 연습 문제집 (구체화 버전)

## 📚 개요

이 연습 문제집은 NumPy와 Pandas 라이브러리에 대한 이해를 높이기 위한 상세한 연습 문제들을 제공합니다. 초급부터 고급까지 단계별로 구성되어 있으며, 각 문제마다 상세한 설명, 해답, 실전 활용 예제를 포함하고 있습니다.

## 🎯 학습 목표

- **NumPy**: 수치 계산과 배열 조작의 기초부터 고급 기법까지
- **Pandas**: 데이터 분석과 조작의 핵심 도구 활용법
- **실전 데이터 분석**: 실제 데이터셋을 활용한 분석 과정
- **시각화**: 데이터 인사이트를 시각적으로 표현하는 방법

## 📖 목차

### 1. NumPy 기초
- [01_numpy_basic_arrays.md](01_numpy_basic_arrays.md) - NumPy 기초 배열 생성
- [02_numpy_indexing_slicing.md](02_numpy_indexing_slicing.md) - NumPy 배열 인덱싱과 슬라이싱

### 2. Pandas 기초
- [03_pandas_series_basics.md](03_pandas_series_basics.md) - Pandas Series 기초
- [04_pandas_dataframe_basics.md](04_pandas_dataframe_basics.md) - Pandas DataFrame 생성과 기초 조작

### 3. 실전 데이터 분석
- [05_data_analysis_titanic.md](05_data_analysis_titanic.md) - 타이타닉 데이터셋을 활용한 실전 분석

## 🚀 시작하기

### 필수 라이브러리 설치

```bash
pip install numpy pandas matplotlib seaborn scipy
```

### 기본 설정

```python
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# 한글 폰트 설정 (필요시)
plt.rcParams['font.family'] = 'DejaVu Sans'
plt.rcParams['axes.unicode_minus'] = False

# 그래프 스타일 설정
plt.style.use('seaborn-v0_8')
sns.set_palette("husl")
```

## 📝 학습 방법

### 1. 순차적 학습
각 파일을 순서대로 학습하시는 것을 권장합니다:
1. NumPy 기초 배열 생성
2. NumPy 인덱싱과 슬라이싱
3. Pandas Series 기초
4. Pandas DataFrame 기초
5. 실전 데이터 분석

### 2. 실습 중심 학습
- 각 문제를 먼저 스스로 풀어보세요
- 해답을 참고하여 이해를 확인하세요
- 추가 연습문제를 통해 실력을 다지세요

### 3. 실전 활용
- 실전 활용 예제를 통해 실제 업무에 적용하는 방법을 학습하세요
- 자신만의 데이터셋으로 연습해보세요

## 🔧 각 챕터 구성

각 Markdown 파일은 다음과 같은 구조로 구성되어 있습니다:

### 📚 학습 목표
- 해당 챕터에서 달성할 수 있는 학습 목표

### 🔍 문제 설명
- 문제의 배경과 실전 활용 사례

### 📝 문제
- 단계별로 구성된 연습 문제들

### 💡 해답 및 설명
- 상세한 해답과 코드 설명

### 🔧 주요 함수/메서드
- 핵심 함수와 메서드의 사용법

### 📊 추가 연습문제
- 더 깊이 있는 학습을 위한 추가 문제

### ⚠️ 주의사항 및 팁
- 실무에서 주의해야 할 점들

### 🎯 실전 활용 예제
- 실제 업무에 적용할 수 있는 예제들

### 📚 다음 단계
- 다음 학습 단계 안내

## 🎯 난이도별 가이드

### 초급 (Beginner)
- **대상**: 프로그래밍 초보자, 데이터 분석 입문자
- **추천 파일**: 01, 03, 04
- **학습 시간**: 2-3주

### 중급 (Intermediate)
- **대상**: 기본 문법을 익힌 학습자
- **추천 파일**: 02, 05
- **학습 시간**: 3-4주

### 고급 (Advanced)
- **대상**: 데이터 분석 경험이 있는 학습자
- **추천 파일**: 전체 파일 + 추가 연습문제
- **학습 시간**: 4-6주

## 💡 학습 팁

### 1. 코드 실행 환경
- **Jupyter Notebook**: 대화형 학습에 적합
- **VS Code**: 코드 편집과 디버깅에 유용
- **Google Colab**: 클라우드 기반 무료 환경

### 2. 실습 방법
- 코드를 직접 타이핑해보세요
- 매개변수를 바꿔가며 실험해보세요
- 에러가 발생하면 디버깅해보세요

### 3. 복습 방법
- 정기적으로 이전 내용을 복습하세요
- 자신만의 예제를 만들어보세요
- 다른 데이터셋으로 연습해보세요

## 🔗 추가 자료

### 공식 문서
- [NumPy 공식 문서](https://numpy.org/doc/stable/)
- [Pandas 공식 문서](https://pandas.pydata.org/docs/)
- [Matplotlib 공식 문서](https://matplotlib.org/)
- [Seaborn 공식 문서](https://seaborn.pydata.org/)

### 온라인 학습 플랫폼
- [Kaggle](https://www.kaggle.com/) - 데이터 사이언스 커뮤니티
- [DataCamp](https://www.datacamp.com/) - 데이터 사이언스 학습
- [Coursera](https://www.coursera.org/) - 온라인 강의

### 실습 데이터셋
- [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/)
- [Kaggle Datasets](https://www.kaggle.com/datasets)
- [Google Dataset Search](https://datasetsearch.research.google.com/)

## 🤝 기여하기

이 연습 문제집을 개선하고 싶으시다면:

1. 새로운 문제나 예제 추가
2. 오류 수정 및 개선 제안
3. 번역 및 지역화
4. 추가 자료 링크 제공

## 📄 라이선스

이 연습 문제집은 교육 목적으로 자유롭게 사용할 수 있습니다.

## 🙏 감사의 말

이 연습 문제집이 여러분의 데이터 분석 학습에 도움이 되기를 바랍니다. 꾸준한 연습과 실습을 통해 데이터 분석 능력을 향상시켜 나가시기 바랍니다.

---

**Happy Learning! 🚀**

*마지막 업데이트: 2024년*
