# 1. NumPy 기초 배열 생성

## 📚 학습 목표
- NumPy 배열의 기본 개념 이해
- 다양한 방법으로 배열 생성하기
- 배열의 형태와 차원 이해하기
- 실전에서 활용할 수 있는 배열 생성 기법 습득

## 🔍 문제 설명

NumPy는 Python에서 수치 계산을 위한 핵심 라이브러리입니다. 데이터 분석, 머신러닝, 과학 계산 등에서 배열을 효율적으로 다루기 위해 사용됩니다. 이번 문제에서는 NumPy의 기본적인 배열 생성 방법들을 연습해보겠습니다.

### 실전 활용 사례
- **데이터 분석**: 대용량 데이터를 효율적으로 처리
- **머신러닝**: 특성(feature) 벡터 생성
- **이미지 처리**: 픽셀 데이터를 배열로 표현
- **금융 분석**: 주가, 수익률 등의 시계열 데이터 처리

## 📝 문제

### 문제 1-1: 기본 배열 생성
1. 0부터 20까지의 짝수만 포함하는 1차원 배열을 생성하세요.
2. 3x3 단위행렬(identity matrix)을 만드세요.
3. 0~1 사이의 난수 10개를 생성하세요.

### 문제 1-2: 다양한 배열 생성 방법
4. 1부터 15까지의 숫자로 3x5 행렬을 만드세요.
5. 모든 원소가 5인 4x4 배열을 생성하세요.
6. 0부터 1까지 0.1 간격으로 배열을 만드세요.

### 문제 1-3: 특수 배열 생성
7. 2차원 배열에서 대각선 원소만 1이고 나머지는 0인 5x5 배열을 만드세요.
8. 1부터 25까지의 숫자로 5x5 배열을 만들고, 짝수만 추출하세요.

## 💡 해답 및 설명

### 해답 1-1: 기본 배열 생성

```python
import numpy as np

# 1. 0부터 20까지의 짝수만 포함하는 1차원 배열
even_numbers = np.arange(0, 21, 2)
print("짝수 배열:", even_numbers)
# 출력: [ 0  2  4  6  8 10 12 14 16 18 20]

# 2. 3x3 단위행렬(identity matrix)
identity_matrix = np.eye(3)
print("\n3x3 단위행렬:")
print(identity_matrix)
# 출력:
# [[1. 0. 0.]
#  [0. 1. 0.]
#  [0. 0. 1.]]

# 3. 0~1 사이의 난수 10개
np.random.seed(42)  # 재현 가능한 결과를 위해 시드 설정
random_numbers = np.random.random(10)
print("\n0~1 사이의 난수 10개:")
print(random_numbers)
# 출력: [0.37454012 0.95071431 0.73199394 0.59865848 0.15601864 0.15599452 0.05808361 0.86617615 0.60111501 0.70807258]
```

### 해답 1-2: 다양한 배열 생성 방법

```python
# 4. 1부터 15까지의 숫자로 3x5 행렬
matrix_3x5 = np.arange(1, 16).reshape(3, 5)
print("3x5 행렬:")
print(matrix_3x5)
# 출력:
# [[ 1  2  3  4  5]
#  [ 6  7  8  9 10]
#  [11 12 13 14 15]]

# 5. 모든 원소가 5인 4x4 배열
array_of_fives = np.full((4, 4), 5)
print("\n모든 원소가 5인 4x4 배열:")
print(array_of_fives)
# 출력:
# [[5 5 5 5]
#  [5 5 5 5]
#  [5 5 5 5]
#  [5 5 5 5]]

# 6. 0부터 1까지 0.1 간격으로 배열
linspace_array = np.linspace(0, 1, 11)
print("\n0부터 1까지 0.1 간격 배열:")
print(linspace_array)
# 출력: [0.  0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1. ]
```

### 해답 1-3: 특수 배열 생성

```python
# 7. 대각선 원소만 1인 5x5 배열
diagonal_matrix = np.eye(5)
print("대각선 원소만 1인 5x5 배열:")
print(diagonal_matrix)

# 8. 1부터 25까지의 숫자로 5x5 배열을 만들고 짝수만 추출
matrix_5x5 = np.arange(1, 26).reshape(5, 5)
print("\n1부터 25까지의 5x5 배열:")
print(matrix_5x5)

even_elements = matrix_5x5[matrix_5x5 % 2 == 0]
print("\n짝수만 추출:")
print(even_elements)
# 출력: [ 2  4  6  8 10 12 14 16 18 20 22 24]
```

## 🔧 주요 함수 설명

### 배열 생성 함수들
- `np.arange(start, stop, step)`: 등차수열 배열 생성
- `np.linspace(start, stop, num)`: 균등 간격 배열 생성
- `np.zeros(shape)`: 0으로 채워진 배열 생성
- `np.ones(shape)`: 1로 채워진 배열 생성
- `np.full(shape, value)`: 특정 값으로 채워진 배열 생성
- `np.eye(n)`: n×n 단위행렬 생성
- `np.random.random(size)`: 0~1 사이의 난수 배열 생성

### 배열 변형 함수들
- `array.reshape(shape)`: 배열의 형태 변경
- `array.flatten()`: 1차원 배열로 평탄화
- `array.T` 또는 `array.transpose()`: 전치(transpose)

## 📊 추가 연습문제

### 연습문제 1
```python
# 다음 문제들을 풀어보세요:
# 1. 1부터 100까지의 홀수만 포함하는 배열을 만드세요.
# 2. 0부터 1까지 0.01 간격으로 배열을 만드세요.
# 3. 모든 원소가 3.14인 2x3 배열을 만드세요.
```

### 연습문제 2
```python
# 다음 문제들을 풀어보세요:
# 1. 1부터 16까지의 숫자로 4x4 배열을 만들고, 
#    대각선 원소들의 합을 구하세요.
# 2. 0부터 9까지의 숫자로 3x3 배열을 만들고,
#    3의 배수만 추출하세요.
```

## ⚠️ 주의사항 및 팁

1. **인덱싱**: NumPy 배열의 인덱스는 0부터 시작합니다.
2. **데이터 타입**: 배열의 모든 원소는 같은 데이터 타입을 가집니다.
3. **메모리 효율성**: NumPy 배열은 Python 리스트보다 메모리 효율적입니다.
4. **브로드캐스팅**: 서로 다른 크기의 배열 간 연산이 가능합니다.
5. **시드 설정**: `np.random.seed()`를 사용하면 재현 가능한 난수를 생성할 수 있습니다.

## 🎯 실전 활용 예제

### 예제 1: 주식 가격 데이터 생성
```python
# 30일간의 주식 가격 데이터 생성
np.random.seed(42)
initial_price = 1000
daily_returns = np.random.normal(0.001, 0.02, 30)  # 일일 수익률
prices = initial_price * (1 + daily_returns).cumprod()
print("30일간 주식 가격:")
print(prices)
```

### 예제 2: 이미지 데이터 시뮬레이션
```python
# 28x28 픽셀의 흑백 이미지 데이터 생성 (MNIST 스타일)
image_data = np.random.randint(0, 256, (28, 28))
print("이미지 데이터 형태:", image_data.shape)
print("픽셀 값 범위:", image_data.min(), "~", image_data.max())
```

## 📚 다음 단계

이제 NumPy 배열 생성의 기본을 익혔습니다. 다음 단계에서는:
- 배열 인덱싱과 슬라이싱
- 배열 연산과 브로드캐스팅
- 조건부 필터링
- 집계 함수 사용법

을 학습하게 됩니다.

---

**참고 자료:**
- [NumPy 공식 문서](https://numpy.org/doc/stable/)
- [NumPy 배열 생성 가이드](https://numpy.org/doc/stable/user/basics.creation.html) 