# NumPy & Pandas 튜토리얼

## 📚 개요

이 폴더에는 NumPy와 Pandas를 학습하기 위한 Jupyter Notebook 형식의 튜토리얼이 포함되어 있습니다.
마크다운 원본 파일은 `markdown/` 폴더에서 찾을 수 있습니다.

## 📁 파일 구조

- **Jupyter Notebook 파일**:
  - `01_numpy_basic_arrays.ipynb` - NumPy 기초 배열 생성
  - `02_numpy_indexing_slicing.ipynb` - NumPy 인덱싱과 슬라이싱
  - `03_pandas_series_basics.ipynb` - Pandas Series 기초
  - `04_pandas_dataframe_basics.ipynb` - Pandas DataFrame 기초
  - `05_data_analysis_titanic.ipynb` - 실전 데이터 분석
  - `README_numpy_pandas.ipynb` - 튜토리얼 가이드

- **마크다운 원본 파일** (`markdown/` 폴더):
  - 위 파일들의 마크다운 버전

## 🚀 시작하기

### 필수 라이브러리 설치
```bash
pip install numpy pandas matplotlib seaborn scipy jupyter
```

### Jupyter Notebook 실행
```bash
# 현재 폴더에서 Jupyter Notebook 서버 실행
jupyter notebook
```

## 📖 학습 순서

1. `01_numpy_basic_arrays.ipynb` - NumPy 기초 배열 생성
2. `02_numpy_indexing_slicing.ipynb` - NumPy 인덱싱과 슬라이싱
3. `03_pandas_series_basics.ipynb` - Pandas Series 기초
4. `04_pandas_dataframe_basics.ipynb` - Pandas DataFrame 기초
5. `05_data_analysis_titanic.ipynb` - 실전 데이터 분석

## 🔧 개발 환경

### 권장 환경
- **Python**: 3.8 이상
- **Jupyter Notebook**: 대화형 학습
- **VS Code**: 코드 편집 및 디버깅 (Jupyter 확장 프로그램 설치)
- **Google Colab**: 클라우드 기반 무료 환경

### 기본 설정
```python
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# 한글 폰트 설정 (필요시)
plt.rcParams['font.family'] = 'DejaVu Sans'
plt.rcParams['axes.unicode_minus'] = False
```

## 📚 추가 자료

### 공식 문서
- [NumPy 공식 문서](https://numpy.org/doc/stable/)
- [Pandas 공식 문서](https://pandas.pydata.org/docs/)
- [Matplotlib 공식 문서](https://matplotlib.org/)
- [Seaborn 공식 문서](https://seaborn.pydata.org/)

---

**Happy Learning! 🚀**

*마지막 업데이트: 2024년* 