# Geumdo Docs - 기술 문서 및 튜토리얼

## 📚 프로젝트 개요

이 저장소는 다양한 기술 문서, 튜토리얼, 그리고 개발 가이드를 포함하는 종합적인 문서 관리 시스템입니다.

## 🗂️ 폴더 구조

```
geumdo_docs/
├── 1_infrastructure/          # 인프라 관련 문서
├── 2_services/               # 서비스 관련 문서
├── 3_development/            # 개발 관련 문서
├── 4_documentation/          # 문서화 관련 자료
├── docs/                     # 문서 및 튜토리얼
│   └── tutorials/           # 튜토리얼 모음
│       └── numpy-pandas/    # NumPy & Pandas 튜토리얼
│           ├── 01_numpy_basic_arrays.ipynb
│           ├── 02_numpy_indexing_slicing.ipynb
│           ├── 03_pandas_series_basics.ipynb
│           ├── 04_pandas_dataframe_basics.ipynb
│           ├── 05_data_analysis_titanic.ipynb
│           ├── README_numpy_pandas.ipynb
│           └── markdown/    # 마크다운 원본 파일
│               ├── README_numpy_pandas.md
│               ├── 01_numpy_basic_arrays.md
│               ├── 02_numpy_indexing_slicing.md
│               ├── 03_pandas_series_basics.md
│               ├── 04_pandas_dataframe_basics.md
│               └── 05_data_analysis_titanic.md
└── README.md                 # 이 파일
```

## 🎯 주요 콘텐츠

### NumPy & Pandas 튜토리얼
- **위치**: `docs/tutorials/numpy-pandas/`
- **내용**: 데이터 분석을 위한 NumPy와 Pandas 라이브러리 학습 가이드
- **대상**: 데이터 분석 입문자부터 중급자까지
- **구성**: 
  - NumPy 기초 (배열 생성, 인덱싱, 슬라이싱)
  - Pandas 기초 (Series, DataFrame)
  - 실전 데이터 분석 (타이타닉 데이터셋)
- **형식**: 
  - 마크다운(.md) 및 Jupyter Notebook(.ipynb) 형식으로 제공

## 🚀 시작하기

### NumPy & Pandas 튜토리얼
```bash
# 튜토리얼 폴더로 이동
cd docs/tutorials/numpy-pandas/

# README 파일 확인 (마크다운)
cat README_numpy_pandas.md

# Jupyter Notebook으로 학습 (권장)
jupyter notebook 01_numpy_basic_arrays.ipynb
```

### 필수 라이브러리 설치
```bash
pip install numpy pandas matplotlib seaborn scipy
```

## 📖 학습 가이드

### 1. 순차적 학습 (권장)
1. `01_numpy_basic_arrays.ipynb` - NumPy 기초 배열 생성
2. `02_numpy_indexing_slicing.ipynb` - NumPy 인덱싱과 슬라이싱
3. `03_pandas_series_basics.ipynb` - Pandas Series 기초
4. `04_pandas_dataframe_basics.ipynb` - Pandas DataFrame 기초
5. `05_data_analysis_titanic.ipynb` - 실전 데이터 분석

※ 마크다운 형식(.md)도 `markdown/` 폴더에 함께 제공됩니다.

### 2. 난이도별 학습
- **초급**: 01, 03, 04번 파일
- **중급**: 02, 05번 파일
- **고급**: 전체 파일 + 추가 연습문제

## 🔧 개발 환경

### 권장 환경
- **Python**: 3.8 이상
- **Jupyter Notebook**: 대화형 학습
- **VS Code**: 코드 편집 및 디버깅
- **Google Colab**: 클라우드 기반 무료 환경

### 기본 설정
```python
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# 한글 폰트 설정 (필요시)
plt.rcParams['font.family'] = 'DejaVu Sans'
plt.rcParams['axes.unicode_minus'] = False
```

## 📚 추가 자료

### 공식 문서
- [NumPy 공식 문서](https://numpy.org/doc/stable/)
- [Pandas 공식 문서](https://pandas.pydata.org/docs/)
- [Matplotlib 공식 문서](https://matplotlib.org/)
- [Seaborn 공식 문서](https://seaborn.pydata.org/)

### 온라인 학습 플랫폼
- [Kaggle](https://www.kaggle.com/) - 데이터 사이언스 커뮤니티
- [DataCamp](https://www.datacamp.com/) - 데이터 사이언스 학습
- [Coursera](https://www.coursera.org/) - 온라인 강의

## 🤝 기여하기

이 프로젝트에 기여하고 싶으시다면:

1. 새로운 튜토리얼이나 문서 추가
2. 기존 내용 개선 및 오류 수정
3. 번역 및 지역화
4. 추가 자료 링크 제공

## 📄 라이선스

이 프로젝트는 교육 목적으로 자유롭게 사용할 수 있습니다.

## 🙏 감사의 말

이 문서들이 여러분의 학습과 개발에 도움이 되기를 바랍니다.

---

**Happy Learning! 🚀**

*마지막 업데이트: 2024년* 