# 프로젝트 구조 개선 및 README.md 관리 방안 분석 보고서

## 1. 현황 분석

현재 프로젝트는 최상위 레벨에 `docker`라는 하나의 큰 디렉토리 안에 연관성 없는 다수의 서비스들이 혼재되어 있습니다. 또한 `nginx`, `rubrics`, `server_backup` 등 다른 목적의 디렉토리들이 함께 있어 전체적인 구조 파악이 어렵습니다.

- **문제점:**
    - 단일 `docker` 디렉토리에 너무 많은 프로젝트가 있어 가독성이 떨어짐
    - 프로젝트들의 성격과 목적이 명확히 구분되지 않음
    - 네이밍 규칙이 일관되지 않음 (`-`와 `_` 혼용)
    - `README.md` 파일이 없거나 내용이 부실한 경우가 많음

## 2. 개선 방안: 폴더 구조 재구성

프로젝트를 **기능별로 분류**하여 최상위 디렉토리 구조를 명확하게 만듭니다. 숫자를 접두사로 사용하여 논리적인 순서와 중요도를 표현합니다.

### 제안하는 폴더 구조

```
.
├── 1_infrastructure/
│   ├── 1_nginx_proxy/
│   ├── 2_docker_registry/
│   └── 3_server_backup/
│
├── 2_services/
│   ├── 1_metaverse/
│   │   ├── backend/      # 기존 nodam
│   │   └── frontend/     # 기존 nodamLand
│   ├── 2_ai/
│   │   ├── 1_geumdo-rag-chat-bot/
│   │   └── 2_vnexa_api/
│   ├── 3_jupyter/
│   │   ├── 1_geumdo_lab/
│   │   └── 2_gpu_docker/
│   ├── 4_web_applications/
│   │   ├── 1_posivibes/
│   │   ├── 2_was/
│   │   ├── 3_was_upgrade/
│   │   └── 4_was_upgrade_http/
│   └── 5_monitoring/
│       └── 1_gpu_cooling_monitor/
│
├── 3_development/
│   ├── 1_environments/
│   │   ├── 1_ubuntu_ssh/
│   │   ├── 2_windows_vm/
│   │   └── 3_securedb/
│   └── 2_examples/
│
├── 4_documentation/
│   ├── 1_rubrics/
│   ├── 2_virtual_scenarios/
│   └── README.md
│
└── README.md # 최상위 README
```

### 구조 변경 상세 설명

- **`1_infrastructure/`**: 다른 애플리케이션을 지원하는 핵심 인프라 서비스들을 모았습니다.
    - `nginx_proxy`, `docker_registry`, `server_backup` 스크립트가 여기에 해당됩니다.
- **`2_services/`**: 사용자에게 직접 제공되는 서비스 애플리케이션들을 모았습니다.
    - **`metaverse/`**: 연관된 `nodam`과 `nodamLand`를 백엔드와 프론트엔드로 통합했습니다.
    - **`ai/`**: AI 관련 프로젝트를 그룹화했습니다.
    - **`jupyter/`**: Jupyter 관련 두 프로젝트를 그룹화했습니다.
    - **`web_applications/`**: 일반 웹 애플리케이션들을 모았습니다.
    - **`monitoring/`**: 모니터링 관련 서비스를 그룹화했습니다.
- **`3_development/`**: 개발 환경 및 예제 코드를 모았습니다.
    - **`environments/`**: 개발 환경 설정을 위한 프로젝트들입니다.
    - **`examples/`**: 예제 코드를 위한 공간입니다.
- **`4_documentation/`**: 프로젝트의 모든 문서들을 중앙에서 관리합니다.
    - `rubrics`, `virtual_scenarios` 등 문서성 파일들을 이곳으로 옮깁니다.

## 3. README.md 추가 및 수정 계획

체계적인 문서화를 위해 각 폴더의 `README.md`를 다음과 같이 관리할 것을 제안합니다.

| 위치                                | README.md 내용                                                                                                                              | 상태 |
| ----------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------- | ---- |
| **`./README.md`**                   | 프로젝트 전체를 소개하고, 새롭게 제안된 최상위 디렉토리 구조(`infrastructure`, `services` 등)에 대해 간략히 설명합니다.                      | 신규 |
| **`1_infrastructure/`**             | 인프라 관련 프로젝트들의 목적과 각 하위 디렉토리(`nginx_proxy` 등)의 역할을 설명하는 `README.md`를 작성합니다.                            | 신규 |
| `1_infrastructure/1_nginx_proxy/`   | `README.md`가 있으나, 새 구조에 맞게 경로 등을 수정하고 서비스의 역할을 명확히 기술합니다.                                                     | 수정 |
| `1_infrastructure/2_docker_registry/` | `README.md`가 있으나, 설정 방법, 사용법 등을 더 상세히 기술합니다.                                                                        | 수정 |
| `1_infrastructure/3_server_backup/`   | `README.md`가 있으나, 각 스크립트의 기능과 실행 방법, 주기 등을 상세히 기술합니다.                                                          | 수정 |
| **`2_services/`**                   | 서비스 관련 프로젝트들의 목적과 각 하위 디렉토리(`metaverse`, `ai` 등)의 역할을 설명하는 `README.md`를 작성합니다.                           | 신규 |
| `2_services/1_metaverse/`             | `backend`(nodam)와 `frontend`(nodamLand)로 구성됨을 설명하고, 전체 메타버스 서비스의 아키텍처와 실행 방법을 기술하는 `README.md`를 작성합니다. | 신규 |
| `2_services/2_ai/...`                 | 각 AI 서비스 폴더 내에 `README.md`가 있으므로, 새 구조에 맞게 경로 등을 수정하고 내용을 보강합니다.                                           | 수정 |
| `2_services/3_jupyter/...`            | 각 Jupyter 서비스 폴더 내에 `README.md`가 있으므로, 새 구조에 맞게 경로 등을 수정하고 내용을 보강합니다.                                     | 수정 |
| `2_services/4_web_applications/...`   | 각 웹 애플리케이션 폴더 내에 `README.md`가 있으므로, 새 구조에 맞게 경로 등을 수정하고 내용을 보강합니다.                                     | 수정 |
| `2_services/5_monitoring/...`         | `gpu_cooling_monitor`의 `README.md`를 새 구조에 맞게 경로 등을 수정하고 내용을 보강합니다.                                                  | 수정 |
| **`3_development/`**                | 개발 환경 및 예제 관련 프로젝트들을 설명하는 `README.md`를 작성합니다.                                                                      | 신규 |
| `3_development/1_environments/...`    | 각 개발 환경 폴더 내의 `README.md`를 새 구조에 맞게 경로 등을 수정하고 내용을 보강합니다.                                                    | 수정 |
| **`4_documentation/`**              | `rubrics`, `virtual_scenarios` 등 어떤 종류의 문서가 있는지 설명하는 `README.md`를 작성합니다.                                               | 신규 |

## 4. 실행 계획 (TODO)

위 분석 내용을 바탕으로 다음과 같은 작업을 진행할 수 있습니다. (`todo.md`로 활용)

1.  **폴더 구조 변경:**
    - `1_infrastructure`, `2_services`, `3_development`, `4_documentation` 상위 폴더 생성
    - 기존 프로젝트들을 새로운 폴더 구조에 맞게 이동
    - `nodam`, `nodamLand`를 `2_services/1_metaverse/` 하위로 통합
2.  **README.md 파일 작성 및 수정:**
    - 최상위 `README.md` 신규 작성
    - 각 분류(`infrastructure`, `services` 등)의 `README.md` 신규 작성
    - 각 개별 프로젝트의 `README.md`를 새 구조에 맞게 내용 수정 및 보강

</rewritten_file> 