# 📚 AI 강의 문서 인덱스 (체계적 정리 완료)

이 문서는 AI 강의 개선 프로젝트에서 생성된 모든 문서와 리소스에 대한 빠른 접근 가이드입니다. 모든 학습 자료가 `ai_lecture/resources/` 디렉터리 아래에 체계적으로 정리되어 있습니다.

---

## 🏗️ 새로운 디렉터리 구조

```
geumdo_docs/
├── ai_lecture/
│   ├── resources/                    # 🎯 모든 학습 자료가 여기에 정리됨
│   │   ├── practice_exercises/       # 연습 문제
│   │   ├── infographics/            # 시각적 학습 자료
│   │   ├── case_studies/            # 케이스 스터디 및 데이터셋
│   │   ├── mlops_examples/          # MLOps 실습 예제
│   │   ├── capstone_guide/          # 캡스톤 프로젝트 가이드
│   │   ├── learning_paths.md        # 학습 경로 가이드
│   │   └── README.md                # 📖 이 디렉터리의 메인 가이드
│   └── [기존 강의 콘텐츠...]
├── PROJECT_IMPROVEMENT_SUMMARY.md    # 전체 프로젝트 완료 보고서
└── DOCUMENT_INDEX.md                 # 이 파일
```

---

## 🐍 파이썬 기초 및 AI 라이브러리

### 📖 학습 자료
- **[파이썬 기초 연습 문제](ai_lecture/resources/practice_exercises/python_basics_practice.md)** - 15개의 단계별 연습 문제
- **[파이썬 데이터 구조 다이어그램](ai_lecture/resources/infographics/python_data_structures.md)** - 시각적 학습 자료
- **[학습 난이도별 경로](ai_lecture/resources/learning_paths.md)** - 초급/중급/고급 학습 로드맵

---

## 🤖 핵심 AI 모델 및 서빙

### 📊 데이터셋 및 케이스 스터디
- **[산업 데이터셋 5개](ai_lecture/resources/case_studies/industry_datasets.md)** - 실제 산업 분야 데이터셋 소개
- **[전자상거래 고객 세분화](ai_lecture/resources/case_studies/1_ecommerce_segmentation.md)** - RFM 분석 케이스 스터디
- **[신용카드 사기 탐지](ai_lecture/resources/case_studies/2_finance_fraud_detection.md)** - 불균형 데이터 처리 케이스 스터디
- **[영화 리뷰 감성 분석](ai_lecture/resources/case_studies/3_nlp_sentiment_analysis.md)** - NLP 케이스 스터디

### 🚀 모델 서빙 실습
- **[FastAPI 모델 서빙 예제](ai_lecture/resources/mlops_examples/model_serving_fastapi_example/README.md)** - 감성 분석 API 구현
- **[FastAPI 메인 코드](ai_lecture/resources/mlops_examples/model_serving_fastapi_example/main.py)** - API 구현 코드
- **[Docker 설정](ai_lecture/resources/mlops_examples/model_serving_fastapi_example/Dockerfile)** - 컨테이너화 설정
- **[Docker Compose](ai_lecture/resources/mlops_examples/model_serving_fastapi_example/docker-compose.yml)** - 개발 환경 설정

---

## 🔧 MLOps 및 고급 AI

### 🔄 CI/CD 파이프라인
- **[GitHub Actions CI/CD](ai_lecture/resources/mlops_examples/.github/workflows/ci-pipeline.yml)** - 자동화 파이프라인

### 📈 모니터링 및 재학습
- **[모니터링 스크립트](ai_lecture/resources/mlops_examples/monitoring_retraining/monitor.py)** - 모델 성능 모니터링
- **[재학습 파이프라인](ai_lecture/resources/mlops_examples/monitoring_retraining/retrain.py)** - 자동 재학습 시스템
- **[MLOps 사용 가이드](ai_lecture/resources/mlops_examples/monitoring_retraining/README.md)** - 모니터링 시스템 사용법

---

## 🎓 캡스톤 프로젝트

### 📋 프로젝트 가이드
- **[단계별 마일스톤 가이드](ai_lecture/resources/capstone_guide/capstone_milestone_guide.md)** - 10주 프로젝트 로드맵
- **[멘토 피드백 시스템](ai_lecture/resources/capstone_guide/mentor_feedback_system_guide.md)** - GitHub 기반 멘토링 가이드

### 🎤 발표 및 평가
- **[발표 가이드라인](ai_lecture/resources/capstone_guide/presentation_guide.md)** - 성공적인 발표를 위한 팁
- **[평가 루브릭](ai_lecture/resources/capstone_guide/evaluation_rubric.md)** - 100점 만점 평가 기준

---

## 📋 프로젝트 관리

### 📝 계획 및 진행 상황
- **[프로젝트 완료 보고서](PROJECT_IMPROVEMENT_SUMMARY.md)** - 전체 개선 사항 요약
- **[학습 자료 메인 가이드](ai_lecture/resources/README.md)** - resources 디렉터리의 상세 가이드

---

## 🚀 빠른 시작 가이드

### 1. 파이썬 기초 학습
```bash
# 1. 학습 경로 확인
cat ai_lecture/resources/learning_paths.md

# 2. 연습 문제 풀기
cat ai_lecture/resources/practice_exercises/python_basics_practice.md

# 3. 데이터 구조 학습
cat ai_lecture/resources/infographics/python_data_structures.md
```

### 2. AI 모델 실습
```bash
# 1. 산업 데이터셋 선택
cat ai_lecture/resources/case_studies/industry_datasets.md

# 2. 케이스 스터디 학습
ls ai_lecture/resources/case_studies/*.md

# 3. FastAPI 모델 서빙 실습
cd ai_lecture/resources/mlops_examples/model_serving_fastapi_example/
python main.py
```

### 3. MLOps 실습
```bash
# 1. 모니터링 시스템 실행
cd ai_lecture/resources/mlops_examples/monitoring_retraining/
python monitor.py
python retrain.py

# 2. CI/CD 파이프라인 확인
cat ai_lecture/resources/mlops_examples/.github/workflows/ci-pipeline.yml
```

### 4. 캡스톤 프로젝트 시작
```bash
# 1. 마일스톤 가이드 확인
cat ai_lecture/resources/capstone_guide/capstone_milestone_guide.md

# 2. 멘토링 시스템 설정
cat ai_lecture/resources/capstone_guide/mentor_feedback_system_guide.md

# 3. 발표 준비
cat ai_lecture/resources/capstone_guide/presentation_guide.md
```

---

## 📞 추가 지원

- **전체 프로젝트 개요:** `PROJECT_IMPROVEMENT_SUMMARY.md` 참조
- **학습 자료 상세 가이드:** `ai_lecture/resources/README.md` 참조
- **기술적 문제:** 각 디렉터리의 README.md 파일 참조

---

## 🎯 주요 변경사항 (v2.0)

✅ **체계적 정리 완료**
- 모든 학습 자료가 `ai_lecture/resources/` 아래로 이동
- 카테고리별 디렉터리 구조 정립
- 중복 파일 제거 및 통합

✅ **접근성 향상**
- 단일 진입점: `ai_lecture/resources/README.md`
- 명확한 파일 경로 구조
- 빠른 시작 가이드 제공

✅ **유지보수성 개선**
- 논리적 디렉터리 구조
- 일관된 네이밍 컨벤션
- 체계적인 문서화

---

**마지막 업데이트:** 2024년 12월  
**문서 버전:** 2.0 (체계적 정리 완료) 