# 캡스톤 프로젝트 채점 루브릭

## 개요
이 루브릭은 AI 강의 과정의 최종 캡스톤 프로젝트에 대한 평가 기준을 제시합니다. 캡스톤 프로젝트는 학생들이 과정 전반에 걸쳐 배운 지식과 기술을 종합적으로 적용하는 실제 문제 해결 프로젝트입니다.

## 평가 영역 및 배점
- 문제 정의 및 기획 (15%)
- 기술적 구현 (30%)
- 결과 분석 및 평가 (20%)
- 프로젝트 관리 및 협업 (15%)
- 발표 및 문서화 (15%)
- 창의성 및 혁신성 (5%)

## 상세 평가 기준

### 1. 문제 정의 및 기획 (15%)

| 성취 수준 | 점수 | 설명 |
|---------|-----|-----|
| 탁월함 | 13-15 | 문제 정의가 매우 명확하고 구체적이며 사회적/기술적 중요성이 잘 설명되어 있다. 프로젝트 목표와 범위가 정교하게 설정되었으며, 달성 가능하면서도 도전적이다. 사용자 요구사항이 포괄적으로 수집되고 체계적으로 분석되었다. 문제 해결을 위한 접근 방법이 매우 체계적이고 잘 정당화되었다. 프로젝트 계획이 철저하고 현실적이며 위험 요소와 대응 방안을 상세히 포함한다. |
| 우수함 | 10-12 | 문제 정의가 명확하고 중요성이 잘 설명되어 있다. 프로젝트 목표와 범위가 잘 설정되었다. 사용자 요구사항이 적절히 수집되고 분석되었다. 문제 해결을 위한 접근 방법이 체계적이다. 프로젝트 계획이 잘 구성되어 있고 주요 위험 요소를 포함한다. |
| 만족스러움 | 7-9 | 문제 정의가 기본적으로 명확하다. 프로젝트 목표와 범위가 설정되었지만 일부 불명확한 부분이 있다. 사용자 요구사항이 수집되었으나 분석이 제한적이다. 문제 해결 접근법이 제시되었지만 일부 근거가 약하다. 프로젝트 계획이 있으나 세부 사항이 부족하다. |
| 개선 필요 | 4-6 | 문제 정의가 모호하거나 불완전하다. 프로젝트 목표와 범위가 불명확하다. 사용자 요구사항 수집이 불충분하다. 문제 해결 접근법이 논리적이지 않거나 근거가 부족하다. 프로젝트 계획이 불완전하다. |
| 미달 | 0-3 | 문제 정의가 부재하거나 크게 불명확하다. 프로젝트 목표와 범위가 설정되지 않았다. 사용자 요구사항이 거의 고려되지 않았다. 문제 해결 접근법이 부적절하다. 프로젝트 계획이 없거나 비현실적이다. |

### 2. 기술적 구현 (30%)

| 성취 수준 | 점수 | 설명 |
|---------|-----|-----|
| 탁월함 | 26-30 | 구현이 매우 완성도 높고 모든 기능 요구사항을 충족한다. 적절한 알고리즘, 데이터 구조, 설계 패턴이 사용되었고 그 선택이 잘 정당화되었다. 코드 품질이 매우 높고, 깨끗하며 유지보수가 용이하다. 시스템 아키텍처가 확장성과 효율성을 갖추도록 최적화되었다. 기술적 도전을 효과적으로 극복했으며 창의적인 해결책을 제시했다. 보안, 확장성, 성능 등 비기능적 요구사항도 충족한다. |
| 우수함 | 20-25 | 구현이 완성도 높고 대부분의 기능 요구사항을 충족한다. 적절한 알고리즘과 데이터 구조가 사용되었다. 코드 품질이 좋고 일관된 스타일을 유지한다. 시스템 아키텍처가 효과적으로 설계되었다. 기술적 도전을 성공적으로 해결했다. 주요 비기능적 요구사항을 고려했다. |
| 만족스러움 | 15-19 | 구현이 기본적인 기능 요구사항을 충족한다. 표준적인 알고리즘과 데이터 구조가 사용되었다. 코드 품질이 수용 가능한 수준이다. 시스템 아키텍처가 기본적인 요구를 충족한다. 일부 기술적 도전을 해결했다. 일부 비기능적 요구사항을 고려했다. |
| 개선 필요 | 9-14 | 구현이 일부 기능 요구사항을 충족하지 못한다. 알고리즘과 데이터 구조 선택이 최적이 아니다. 코드 품질이 불균일하다. 시스템 아키텍처에 개선이 필요하다. 기술적 도전을 부분적으로만 해결했다. 비기능적 요구사항에 대한 고려가 부족하다. |
| 미달 | 0-8 | 구현이 대부분의 기능 요구사항을 충족하지 못한다. 부적절한 알고리즘과 데이터 구조가 사용되었다. 코드 품질이 낮다. 시스템 아키텍처가 부적절하다. 기술적 도전을 해결하지 못했다. 비기능적 요구사항을 거의 고려하지 않았다. |

### 3. 결과 분석 및 평가 (20%)

| 성취 수준 | 점수 | 설명 |
|---------|-----|-----|
| 탁월함 | 18-20 | 프로젝트 결과와 목표 달성 정도를 포괄적이고 정확하게 평가했다. 적절하고 다양한 정량적/정성적 평가 방법을 사용했다. 테스트와 검증이 철저하게 수행되었고 상세히 문서화되었다. 결과에 대한 해석이 깊이 있고 통찰력 있으며, 한계점을 명확히 인식하고 있다. 개선을 위한 구체적이고 실현 가능한 제안을 포함한다. 사용자 피드백을 체계적으로 수집하고 분석하여 반영했다. |
| 우수함 | 14-17 | 프로젝트 결과와 목표 달성 정도를 적절하게 평가했다. 정량적/정성적 평가 방법을 균형있게 사용했다. 테스트와 검증이 충분히 수행되었고 문서화되었다. 결과에 대한 해석이 명확하며, 주요 한계점을 인식하고 있다. 개선을 위한 유용한 제안을 포함한다. 사용자 피드백을 수집하고 분석했다. |
| 만족스러움 | 10-13 | 프로젝트 결과와 목표 달성 정도를 기본적으로 평가했다. 일부 평가 방법을 사용했다. 기본적인 테스트와 검증이 수행되었다. 결과에 대한 해석이 제공되었으나 깊이가 부족하다. 일부 한계점을 인식하고 있다. 개선을 위한 일반적인 제안을 포함한다. 기본적인 사용자 피드백을 고려했다. |
| 개선 필요 | 6-9 | 프로젝트 결과와 목표 달성 정도에 대한 평가가 불충분하다. 평가 방법이 제한적이거나 부적절하다. 테스트와 검증이 불완전하게 수행되었다. 결과 해석이 표면적이다. 한계점에 대한 인식이 부족하다. 개선을 위한 제안이 모호하다. 사용자 피드백이 거의 고려되지 않았다. |
| 미달 | 0-5 | 프로젝트 결과와 목표 달성 정도에 대한 평가가 거의 없다. 평가 방법이 없거나 부적절하다. 테스트와 검증이 거의 수행되지 않았다. 결과 해석이 없거나 오해의 소지가 있다. 한계점이 파악되지 않았다. 개선을 위한 제안이 없다. 사용자 피드백이 고려되지 않았다. |

### 4. 프로젝트 관리 및 협업 (15%)

| 성취 수준 | 점수 | 설명 |
|---------|-----|-----|
| 탁월함 | 13-15 | 프로젝트가 체계적으로 관리되었으며 모든 일정과 목표를 성공적으로 달성했다. 팀 역할과 책임이 명확하게 정의되고 효과적으로 분담되었다. 의사소통이 매우 원활하며 정기적인 미팅과 명확한 의사결정 과정이 있었다. 문제와 갈등을 효과적으로 해결하고 적응적인 접근 방식을 보였다. 버전 관리와 문서화가 매우 체계적이다. 팀원들의 참여도가 높고 균형 있게 기여했다. |
| 우수함 | 10-12 | 프로젝트가 잘 관리되었으며 대부분의 일정과 목표를 달성했다. 팀 역할과 책임이 잘 정의되고 분담되었다. 의사소통이 원활하며 정기적인 미팅이 있었다. 문제와 갈등을 적절히 해결했다. 버전 관리와 문서화가 체계적이다. 팀원들이 적극적으로 참여하고 기여했다. |
| 만족스러움 | 7-9 | 프로젝트 관리가 기본적으로 이루어졌으며 일부 일정 지연이 있었지만 대체로 목표를 달성했다. 팀 역할과 책임이 어느 정도 정의되었다. 기본적인 의사소통이 이루어졌다. 발생한 문제들을 해결하기 위해 노력했다. 버전 관리와 문서화가 기본적인 수준으로 이루어졌다. 팀원들의 참여에 다소 불균형이 있었다. |
| 개선 필요 | 4-6 | 프로젝트 관리가 불충분하며 일정 지연이 상당했고 일부 목표를 달성하지 못했다. 팀 역할과 책임이 불명확했다. 의사소통이 불규칙하고 효과적이지 않았다. 문제 해결이 지연되거나 부적절했다. 버전 관리와 문서화가 불충분했다. 팀원들의 참여가 불균형했다. |
| 미달 | 0-3 | 프로젝트 관리가 매우 부족했으며 대부분의 일정을 놓치고 목표를 달성하지 못했다. 팀 역할과 책임이 정의되지 않았다. 의사소통이 거의 없거나 비효율적이었다. 문제 해결이 이루어지지 않았다. 버전 관리와 문서화가 거의 없었다. 팀 참여가 매우 불균형했다. |

### 5. 발표 및 문서화 (15%)

| 성취 수준 | 점수 | 설명 |
|---------|-----|-----|
| 탁월함 | 13-15 | 발표가 매우 전문적이고 명확하며 청중의 이해를 돕는 효과적인 시각 자료를 포함한다. 프로젝트의 모든 중요한 측면을 포괄적으로 다루며 시간 제한을 잘 지켰다. 질문에 대한 응답이 매우 정확하고 통찰력 있다. 프로젝트 문서가 매우 상세하고 명확하며 잘 구성되어 있다. README, 사용자 가이드, API 문서 등 모든 필요한 문서가 완벽하게 제공된다. 코드에 포괄적인 주석이 있고 쉽게 이해할 수 있다. |
| 우수함 | 10-12 | 발표가 전문적이고 명확하며 적절한 시각 자료를 포함한다. 프로젝트의 주요 측면을 잘 다루며 시간 제한을 대체로 지켰다. 질문에 대한 응답이 정확하다. 프로젝트 문서가 상세하고 잘 구성되어 있다. 필요한 대부분의 문서가 제공된다. 코드에 적절한 주석이 있다. |
| 만족스러움 | 7-9 | 발표가 기본적인 정보를 전달하고 일부 시각 자료를 포함한다. 프로젝트의 핵심 측면을 다루었으나 일부 중요한 내용이 누락되었다. 시간 관리에 약간의 문제가 있었다. 질문에 대체로 적절히 응답했다. 프로젝트 문서가 기본적인 정보를 제공한다. 필수적인 문서는 있으나 일부 세부 사항이 부족하다. 코드에 기본적인 주석이 있다. |
| 개선 필요 | 4-6 | 발표가 불명확하거나 불완전하며 시각 자료가 효과적이지 않다. 프로젝트의 일부 측면만 다루었다. 시간 관리에 문제가 있었다. 질문에 대한 응답이 불완전하다. 프로젝트 문서가 불충분하거나 구성이 좋지 않다. 일부 필수 문서가 누락되었다. 코드 주석이 부족하다. |
| 미달 | 0-3 | 발표가 매우 불명확하고 비효과적이다. 프로젝트의 중요한 측면을 거의 다루지 않았다. 시간 관리가 매우 좋지 않았다. 질문에 적절히 응답하지 못했다. 프로젝트 문서가 매우 불충분하거나 없다. 대부분의 필수 문서가 누락되었다. 코드 주석이 거의 없다. |

### 6. 창의성 및 혁신성 (5%)

| 성취 수준 | 점수 | 설명 |
|---------|-----|-----|
| 탁월함 | 5 | 프로젝트가 매우 독창적이고 혁신적인 아이디어나 접근법을 포함한다. 기존 해결책을 넘어서는 새로운 관점이나 기법을 적용했다. 창의적인 문제 해결 능력이 뛰어나다. 사용자 경험이나 기술 적용에 있어 독창적인 요소가 돋보인다. |
| 우수함 | 4 | 프로젝트가 독창적인 요소와 창의적인 접근법을 포함한다. 기존 해결책에 유의미한 개선이나 변형을 추가했다. 문제 해결에 창의적인 사고를 적용했다. |
| 만족스러움 | 3 | 프로젝트가 일부 독창적인 요소를 포함한다. 기존 해결책에 약간의 변형을 추가했다. 표준적인 접근법에서 벗어나는 시도가 있었다. |
| 개선 필요 | 2 | 프로젝트가 대부분 기존의 접근법과 기법을 따르며 독창성이 제한적이다. 창의적인 요소가 거의 없다. |
| 미달 | 0-1 | 프로젝트가 기존 접근법을 그대로 따르며 독창성이나 혁신적인 요소가 전혀 없다. |

## 종합 평가 기준

| 등급 | 총점 범위 | 설명 |
|-----|---------|-----|
| A+ | 90-100 | 탁월한 캡스톤 프로젝트. 모든 측면에서 뛰어나며 전문적인 수준의 완성도와 창의성을 보여준다. |
| A | 85-89 | 매우 우수한 캡스톤 프로젝트. 대부분의 측면에서 뛰어나며 높은 완성도를 보여준다. |
| B+ | 80-84 | 우수한 캡스톤 프로젝트. 많은 부분에서 기대 이상의 결과를 보여주었다. |
| B | 75-79 | 양호한 캡스톤 프로젝트. 대부분의 요구사항을 충족하고 일정 수준 이상의 품질을 보여주었다. |
| C+ | 70-74 | 만족스러운 캡스톤 프로젝트. 핵심 요구사항은 충족했으나 개선의 여지가 많다. |
| C | 60-69 | 기본적인 캡스톤 프로젝트. 최소한의 요구사항을 충족했지만 완성도가 낮다. |
| F | 0-59 | 미달. 기본적인 요구사항을 충족하지 못했다. |

## 피드백 제공 지침
- 각 평가 영역별로 구체적인 피드백을 제공합니다.
- 프로젝트의 강점과 개선이 필요한 부분을 명확히 지적합니다.
- 특히 프로젝트의 독창성, 기술적 구현, 문제 해결 능력에 대해 구체적으로 언급합니다.
- 향후 개선이나 확장을 위한 실용적인 제안을 포함합니다.
- 팀 협업과 개인 기여도에 관한 피드백도 제공합니다. 