import json
import sys

def fix_notebook_file(file_path):
    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            nb = json.load(f)

        if nb['cells']:
            first_cell = nb['cells'][0]
            if first_cell.get('cell_type') == 'code':
                print(f"Fixing {file_path}...")
                first_cell['cell_type'] = 'markdown'
                if 'execution_count' in first_cell:
                    del first_cell['execution_count']
                if 'outputs' in first_cell:
                    del first_cell['outputs']
                
                with open(file_path, 'w', encoding='utf-8') as f:
                    json.dump(nb, f, indent=1, ensure_ascii=False)
                print(f"Successfully fixed {file_path}")
            else:
                print(f"No fix needed for {file_path} (first cell is not a code cell).")
        else:
            print(f"No cells found in {file_path}.")

    except Exception as e:
        print(f"An error occurred while processing {file_path}: {e}")

if __name__ == "__main__":
    if len(sys.argv) > 1:
        for file_path in sys.argv[1:]:
            fix_notebook_file(file_path)
    else:
        print("Usage: python fix_notebook.py <path_to_notebook1.ipynb> <path_to_notebook2.ipynb> ...") 