# 금융 산업 가상 실습 환경 시나리오

## 시나리오 개요
이 실습 환경은 금융 기관에서 사용되는 사기 거래 탐지 시스템을 개발하고 배포하는 과정을 시뮬레이션합니다. 학습자는 실시간 거래 데이터에서 이상 거래를 탐지하는 머신러닝 모델을 구축하게 됩니다.

## 학습 목표
- 금융 거래 데이터 분석 및 전처리 기법 습득
- 불균형 데이터에 대한 분류 모델 훈련 방법 학습
- 실시간 추론을 위한 모델 최적화 기법 습득
- 금융 규제 및 보안 요구사항을 준수하는 시스템 설계

## 데이터셋
- [IEEE-CIS Fraud Detection](https://www.kaggle.com/c/ieee-fraud-detection/data) 데이터셋 변형 버전
- 익명화된 신용카드 거래 샘플 데이터

## 실습 단계
1. **데이터 전처리 및 탐색**
   - 시계열 거래 데이터 특성 추출
   - 이상치 분석 및 처리
   - 특성 중요도 평가 및 선택

2. **모델 개발**
   - 앙상블 기반 사기 탐지 모델 구현
   - 비용 민감형 학습 알고리즘 적용
   - 실시간 추론을 위한 모델 경량화

3. **성능 평가**
   - 사기 탐지의 정확도, 재현율, 정밀도 균형
   - 오탐지율(False Positive Rate) 최소화
   - 금융 비용 관점의 모델 성능 평가

4. **배포 시뮬레이션**
   - 실시간 스트리밍 데이터 처리 파이프라인 구축
   - A/B 테스트 및 단계적 출시 전략
   - 모델 모니터링 및 성능 저하 알림 시스템 구현
   - PCI-DSS 및 금융 보안 규제 준수 아키텍처 설계

## 평가 기준
- 모델의 사기 탐지 정확도 및 신속성
- 오탐지로 인한 사용자 불편 최소화 전략
- 실시간 처리 시스템의 확장성 및 안정성
- 금융 규제 준수 및 데이터 보안 수준 