# 강의 섹션별 퀴즈 및 미니 테스트 구조

## 개요
각 강의 섹션별로 학생들의 이해도를 평가하고 강화하기 위한 퀴즈와 미니 테스트를 개발합니다. 각 섹션마다 다양한 유형의 문제를 제공하여 학습 내용을 다각도로 평가합니다.

## 퀴즈 구조
각 퀴즈는 다음과 같은 요소를 포함합니다:

1. **기본 정보**
   - 퀴즈 제목
   - 관련 강의 섹션
   - 난이도 (상/중/하)
   - 예상 소요 시간

2. **문제 유형**
   - 객관식 문제
   - 주관식 문제
   - 참/거짓 문제
   - 코드 완성하기
   - 오류 찾기

3. **채점 기준**
   - 정답 배점
   - 부분 점수 적용 여부
   - 자동 채점 가능 여부

## 미니 테스트 구조
미니 테스트는 퀴즈보다 더 포괄적이며 다음 요소를 포함합니다:

1. **기본 정보**
   - 테스트 제목
   - 관련 강의 섹션
   - 난이도 (상/중/하)
   - 예상 소요 시간 (15-30분)

2. **문제 구성**
   - 이론 문제 (50%)
   - 실습 문제 (50%)
   - 다양한 유형의 문제 조합

3. **채점 기준**
   - 문제별 배점
   - 종합 평가 기준
   - 피드백 제공 방식

## 섹션별 개발 계획
강의는 크게 다음과 같은 섹션으로 구분됩니다:

1. **파트 0-5: 파이썬 기초 및 AI 라이브러리**
   - 파이썬 기초 문법
   - 데이터 구조 및 알고리즘
   - 데이터 분석 기초 (Numpy, Pandas)
   - 시각화 도구 (Matplotlib, Seaborn)
   - 기계학습 라이브러리 기초 (Scikit-learn)

2. **파트 6-9: 핵심 AI 모델 및 서빙**
   - 지도 학습 모델
   - 비지도 학습 모델
   - 딥러닝 기초 (Tensorflow/PyTorch)
   - 모델 서빙 및 배포

3. **파트 10-14: MLOps 및 고급 AI**
   - MLOps 기초
   - 데이터 파이프라인
   - 모델 모니터링 및 재학습
   - 고급 AI 응용

4. **파트 15: 캡스톤 프로젝트**
   - 프로젝트 계획 및 설계
   - 구현 및 테스트
   - 배포 및 발표

각 섹션별로 10개의 퀴즈와 미니 테스트를 개발하여 학습 내용을 포괄적으로 평가합니다. 