# 미니 테스트: 핵심 AI 모델 - 지도 학습

## 기본 정보
- **제목**: 지도 학습 모델 미니 테스트
- **관련 섹션**: 파트 6-7 (핵심 AI 모델 - 지도 학습)
- **난이도**: 중상
- **예상 소요 시간**: 30분

## 이론 파트 (50점)

### 1. 모델 개념 이해 (10점)
다음 중 의사결정 트리(Decision Tree)의 특성으로 올바르지 않은 것은?

1. 비선형 관계를 모델링할 수 있다
2. 데이터의 스케일링이 필요하지 않다
3. 정보 이득(Information Gain)이나 지니 불순도(Gini Impurity)를 기반으로 분기를 결정한다
4. 이상치(Outlier)에 매우 민감하다

**정답**: 4

### 2. 앙상블 방법 (10점)
다음 중 랜덤 포레스트(Random Forest)에 대한 설명으로 올바른 것은?

1. 여러 개의 약한 모델을 순차적으로 학습시켜 이전 모델의 오류를 보완한다
2. 다수의 의사결정 트리를 병렬적으로 학습시키고 다수결 원칙으로 예측 결과를 결정한다
3. 데이터의 차원을 줄이는 전처리 기법으로 주로 사용된다
4. 서포트 벡터 머신보다 해석하기 쉽다는 장점이 있다

**정답**: 2

### 3. 모델 비교 (10점)
다음 중 로지스틱 회귀와 선형 회귀의 차이점으로 올바른 것은?

1. 로지스틱 회귀는 분류 문제에, 선형 회귀는 회귀 문제에 주로 사용된다
2. 로지스틱 회귀는 비선형 관계를 모델링할 수 있지만 선형 회귀는 불가능하다
3. 선형 회귀는 확률을 예측하지만 로지스틱 회귀는 직접적인 값을 예측한다
4. 로지스틱 회귀는 L1, L2 정규화를 사용할 수 없지만 선형 회귀는 가능하다

**정답**: 1

### 4. 하이퍼파라미터의 영향 (10점)
SVM(Support Vector Machine)의 C 파라미터가 모델에 미치는 영향은?

1. C값이 커지면 마진이 커지고 모델이 더 단순해진다
2. C값이 커지면 마진이 작아지고 오분류를 더 엄격하게 처리한다
3. C값은 커널 함수의 종류를 결정한다
4. C값이 작아지면 비선형성이 증가한다

**정답**: 2

### 5. 회귀 모델 성능 평가 (10점)
회귀 문제에서 모델의 성능을 평가하는 데 사용되지 않는 지표는?

1. MSE(Mean Squared Error)
2. MAE(Mean Absolute Error)
3. F1 점수
4. R² (결정 계수)

**정답**: 3

## 실습 파트 (50점)

### 6. 코드 이해 (10점)
다음 코드가 수행하는 작업을 올바르게 설명한 것은?

```python
from sklearn.model_selection import GridSearchCV
from sklearn.ensemble import RandomForestClassifier

param_grid = {
    'n_estimators': [50, 100, 200],
    'max_depth': [None, 10, 20],
    'min_samples_split': [2, 5, 10]
}

rf = RandomForestClassifier(random_state=42)
grid_search = GridSearchCV(rf, param_grid, cv=5, scoring='accuracy')
grid_search.fit(X_train, y_train)
```

1. 랜덤 포레스트 모델의 성능을 5-fold 교차 검증으로 평가한다
2. 랜덤 포레스트의 다양한 하이퍼파라미터 조합을 탐색하여 최적의 조합을 찾는다
3. 특성 중요도를 기반으로 최상의 특성을 선택한다
4. 랜덤 포레스트의 앙상블에 사용되는 의사결정 트리의 수를 최적화한다

**정답**: 2

### 7. 피처 중요도 분석 (10점)
아래 코드에서 `feature_importances_`가 어떤 정보를 제공하는지 설명하시오.

```python
from sklearn.ensemble import RandomForestClassifier

model = RandomForestClassifier()
model.fit(X_train, y_train)
importances = model.feature_importances_
```

**정답**:
`feature_importances_`는 랜덤 포레스트 모델에서 각 특성(feature)이 예측에 얼마나 중요한 역할을 하는지 나타내는 점수를 제공합니다. 이 점수는 0과 1 사이의 값을 가지며, 모든 특성의 중요도 점수의 합은 1입니다. 값이 클수록 해당 특성이 모델의 예측에 더 큰 영향을 미친다는 것을 의미합니다.

### 8. 편향-분산 트레이드오프 (10점)
다음 상황에서 발생한 문제와 그 해결책을 설명하시오.

```
훈련 세트 정확도: 99.8%
테스트 세트 정확도: 82.3%
```

**정답**:
이 상황은 과적합(overfitting)을 나타냅니다. 모델이 훈련 데이터에 너무 맞춰져 있어 일반화 성능이 떨어진 것입니다. 해결책으로는:
1. 정규화(regularization) 적용 (L1, L2 등)
2. 모델의 복잡도 줄이기 (예: 의사결정 트리의 깊이 제한)
3. 더 많은 훈련 데이터 사용
4. 특성 선택 또는 차원 축소
5. 앙상블 기법 활용 (예: 배깅, 부스팅)

### 9. 코드 작성 (10점)
다음 요구사항을 만족하는 코드를 작성하시오:
1. 데이터를 70:30 비율로 훈련/테스트 세트로 분할
2. 표준화(StandardScaler) 전처리 적용
3. 로지스틱 회귀 모델 훈련
4. 정밀도, 재현율, F1 점수 계산

**정답**:
```python
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import precision_score, recall_score, f1_score

# 1. 데이터 분할
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

# 2. 표준화 적용
scaler = StandardScaler()
X_train_scaled = scaler.fit_transform(X_train)
X_test_scaled = scaler.transform(X_test)

# 3. 모델 훈련
model = LogisticRegression()
model.fit(X_train_scaled, y_train)

# 4. 예측 및 성능 지표 계산
y_pred = model.predict(X_test_scaled)
precision = precision_score(y_test, y_pred)
recall = recall_score(y_test, y_pred)
f1 = f1_score(y_test, y_pred)

print(f"정밀도: {precision:.4f}")
print(f"재현율: {recall:.4f}")
print(f"F1 점수: {f1:.4f}")
```

### 10. 실제 문제 해결 (10점)
당신은 신용카드 사기 탐지 모델을 개발하고 있습니다. 데이터셋에는 정상 거래가 99.7%, 사기 거래가 0.3%를 차지하는 심한 불균형이 있습니다. 다음 질문에 답하시오:

a) 이러한 불균형 데이터에서 단순 정확도(accuracy)가 성능 평가에 적합하지 않은 이유는?

b) 대신 어떤 평가 지표를 사용해야 하며 그 이유는?

c) 불균형 데이터를 해결하기 위한 두 가지 방법을 설명하시오.

**정답**:
a) 단순히 모든 거래를 '정상'으로 분류하는 모델도 99.7%의 정확도를 얻을 수 있기 때문입니다. 이런 모델은 정확도는 높지만 실제로는 사기 거래를 전혀 탐지하지 못하므로 쓸모가 없습니다.

b) 불균형 데이터에서는 다음 지표들이 더 적합합니다:
- 정밀도(Precision): 사기로 분류된 거래 중 실제 사기의 비율
- 재현율(Recall): 실제 사기 중 모델이 탐지한 비율
- F1 점수: 정밀도와 재현율의 조화평균
- AUC-ROC/AUC-PR: 다양한 임계값에서의 모델 성능을 평가
특히 사기 탐지에서는 재현율이 중요할 수 있습니다(사기를 놓치는 비용이 높기 때문).

c) 불균형 데이터 해결 방법:
1. 리샘플링:
   - 오버샘플링: SMOTE, ADASYN 등을 사용하여 소수 클래스(사기) 데이터를 증가시킴
   - 언더샘플링: 다수 클래스(정상) 데이터를 줄임
2. 알고리즘 수준의 접근:
   - 클래스 가중치 부여: 소수 클래스에 더 높은 가중치를 할당
   - 비용에 민감한(cost-sensitive) 학습
   - 앙상블 기법(예: EasyEnsemble, BalancedRandomForestClassifier)

## 채점 기준
- 객관식 문제: 정답이면 만점, 오답이면 0점
- 단답형 문제: 핵심 개념을 정확히 설명하면 만점
- 코드 작성 문제: 기능적으로 올바른 해결책을 제시하면 만점
- 실제 문제 해결: 각 하위 질문에 대해 적절하게 답변하면 만점 