# 퀴즈: 파이썬 기초 문법

## 기본 정보
- **제목**: 파이썬 기초 문법 퀴즈
- **관련 섹션**: 파트 0-1 (파이썬 기초)
- **난이도**: 하
- **예상 소요 시간**: 10분

## 문제

### 1. 변수와 데이터 타입 (10점)
다음 중 파이썬에서 올바른 변수 선언 방법은 무엇인가요?
1. var 1 = 10
2. 1var = 10
3. var_1 = 10
4. var-1 = 10

**정답**: 3

### 2. 문자열 처리 (10점)
다음 코드의 출력 결과는 무엇인가요?
```python
text = "Python Programming"
print(text[7:])
```

**정답**: Programming

### 3. 리스트 조작 (10점)
다음 코드의 출력 결과는 무엇인가요?
```python
numbers = [1, 2, 3, 4, 5]
numbers.append(6)
numbers.insert(0, 0)
print(numbers)
```

**정답**: [0, 1, 2, 3, 4, 5, 6]

### 4. 조건문 (10점)
다음 코드에서 출력되는 값은 무엇인가요?
```python
x = 5
if x > 10:
    print("A")
elif x > 5:
    print("B")
elif x == 5:
    print("C")
else:
    print("D")
```

**정답**: C

### 5. 반복문 (10점)
다음 코드의 출력 결과는 무엇인가요?
```python
total = 0
for i in range(1, 6):
    if i % 2 == 0:
        total += i
print(total)
```

**정답**: 6

### 6. 함수 정의 (10점)
다음 중 파이썬 함수를 올바르게 정의한 것은 무엇인가요?
1. function add(a, b) { return a + b; }
2. def add(a, b): return a + b
3. def add(a, b) { return a + b }
4. function add(a, b): return a + b

**정답**: 2

### 7. 참/거짓 (10점)
파이썬에서 다음 중 False로 평가되지 않는 것은?
1. 0
2. ""
3. []
4. "False"

**정답**: 4

### 8. 코드 완성 (10점)
다음 코드를 완성하여 1부터 n까지의 합을 계산하는 함수를 만드세요.
```python
def sum_to_n(n):
    # 코드를 작성하세요
    __________
    __________
    __________
```

**정답**:
```python
def sum_to_n(n):
    total = 0
    for i in range(1, n+1):
        total += i
    return total
```

### 9. 오류 찾기 (10점)
다음 코드에 오류가 있다면 찾아내고 수정하세요.
```python
def calculate_average(numbers):
    total = 0
    for num in numbers:
        total += num
    return total / len(numbers)
    
result = calculate_average([])
print(result)
```

**정답**: 빈 리스트로 나누려고 할 때 ZeroDivisionError가 발생합니다. 다음과 같이 수정해야 합니다.
```python
def calculate_average(numbers):
    if not numbers:  # 리스트가 비어있는 경우 처리
        return 0
    total = 0
    for num in numbers:
        total += num
    return total / len(numbers)
```

### 10. 주관식 (10점)
파이썬에서 'list comprehension'의 기본 문법을 작성하고 간단한 예시를 들어보세요.

**정답 예시**: 
리스트 컴프리헨션의 기본 문법은 `[표현식 for 항목 in 반복가능객체 if 조건문]`입니다.
예: `squares = [x**2 for x in range(10) if x % 2 == 0]`는 0부터 9까지의 짝수의 제곱을 포함하는 리스트 `[0, 4, 16, 36, 64]`를 생성합니다.

## 채점 기준
- 각 문제는 10점 만점이며, 총점은 100점입니다.
- 객관식과 참/거짓 문제는 정답을 맞힐 경우 만점, 틀릴 경우 0점입니다.
- 코드 완성 및 오류 찾기 문제는 기능적으로 올바른 해결책을 제시할 경우 만점입니다.
- 주관식 문제는 핵심 개념을 올바르게 설명하고 적절한 예시를 제시할 경우 만점입니다. 