# 퀴즈: 기계학습 라이브러리 기초 (Scikit-learn)

## 기본 정보
- **제목**: 기계학습 라이브러리 기초 퀴즈
- **관련 섹션**: 파트 4-5 (기계학습 라이브러리)
- **난이도**: 중상
- **예상 소요 시간**: 20분

## 문제

### 1. Scikit-learn 주요 모듈 (10점)
Scikit-learn에서 데이터 전처리를 위한 주요 모듈은 무엇인가요?
1. `sklearn.preprocessing`
2. `sklearn.prepare`
3. `sklearn.dataprep`
4. `sklearn.transform`

**정답**: 1

### 2. 모델 평가 지표 (10점)
분류 문제에서 모델의 성능을 평가하는 지표로 적절하지 않은 것은?
1. 정확도(Accuracy)
2. 정밀도(Precision)
3. 재현율(Recall)
4. 평균 제곱 오차(Mean Squared Error)

**정답**: 4

### 3. 교차 검증 (10점)
Scikit-learn에서 k-fold 교차 검증을 구현하는 함수는?
1. `sklearn.model_selection.KFold`
2. `sklearn.validation.cross_validate`
3. `sklearn.metrics.cross_val_score`
4. `sklearn.model_selection.cross_val_score`

**정답**: 4

### 4. 데이터 스케일링 (10점)
다음 중 MinMaxScaler의 기능으로 올바른 것은?
1. 각 특성을 평균이 0, 표준편차가 1이 되도록 변환한다
2. 각 특성을 최소값이 0, 최대값이 1이 되도록 변환한다
3. 특성 간의 상관관계를 제거한다
4. 이상치(outlier)에 강건한 정규화를 수행한다

**정답**: 2

### 5. 하이퍼파라미터 튜닝 (10점)
Scikit-learn에서 그리드 서치(Grid Search)를 수행하기 위한 클래스는?
1. `sklearn.model_selection.GridSearch`
2. `sklearn.tuning.GridSearchCV`
3. `sklearn.model_selection.GridSearchCV`
4. `sklearn.hyperparameter.GridSearch`

**정답**: 3

### 6. 차원 축소 (10점)
다음 중 PCA(Principal Component Analysis)에 대한 설명으로 올바르지 않은 것은?
1. 비지도 학습 알고리즘이다
2. 데이터의 분산을 최대화하는 방향으로 차원을 축소한다
3. 데이터를 원래 공간으로 완벽하게 복원할 수 있다
4. 고차원 데이터의 시각화에 유용하다

**정답**: 3

### 7. 모델 파이프라인 (10점)
Scikit-learn의 Pipeline 클래스의 주요 이점이 아닌 것은?
1. 전처리와 모델링 단계를 하나로 묶어 코드를 간소화한다
2. 교차 검증 시 데이터 누출을 방지한다
3. 여러 전처리 단계와 모델을 순차적으로 적용할 수 있다
4. 모델의 정확도를 자동으로 향상시킨다

**정답**: 4

### 8. 코드 완성 (10점)
다음 코드를 완성하여 데이터를 훈련/테스트 세트로 분할하고 모델을 학습시킨 후 평가하세요.
```python
from sklearn.model_selection import train_test_split
from sklearn.ensemble import RandomForestClassifier
from sklearn.metrics import accuracy_score

def train_and_evaluate(X, y):
    # 코드를 작성하세요
    __________
    __________
    __________
    __________
    return model, accuracy

# 예시 사용:
# X = features, y = labels
# model, acc = train_and_evaluate(X, y)
```

**정답**:
```python
from sklearn.model_selection import train_test_split
from sklearn.ensemble import RandomForestClassifier
from sklearn.metrics import accuracy_score

def train_and_evaluate(X, y):
    # 데이터 분할
    X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)
    
    # 모델 학습
    model = RandomForestClassifier()
    model.fit(X_train, y_train)
    
    # 예측 및 평가
    y_pred = model.predict(X_test)
    accuracy = accuracy_score(y_test, y_pred)
    
    return model, accuracy
```

### 9. 오류 찾기 (10점)
다음 코드에 오류가 있다면 찾아내고 수정하세요.
```python
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LogisticRegression
from sklearn.pipeline import Pipeline

# 파이프라인 생성
pipe = Pipeline([
    ('scaler', StandardScaler()),
    ('classifier', LogisticRegression())
])

# 모델 학습
pipe.fit(X_train)

# 예측
predictions = pipe.predict(X_test)
```

**정답**: `pipe.fit(X_train)`에 y_train이 누락되었습니다. 지도학습 모델을 학습할 때는 X와 y를 모두 제공해야 합니다.

```python
# 모델 학습
pipe.fit(X_train, y_train)
```

### 10. 주관식 (10점)
Scikit-learn에서 특성 선택(Feature Selection)의 세 가지 주요 방법을 설명하고 각 방법의 장단점을 비교하세요.

**정답 예시**: 
Scikit-learn에서 특성 선택의 세 가지 주요 방법:

1. **필터 방법(Filter Methods)**:
   - 특성과 목표 변수 간의 통계적 관계를 기반으로 선택
   - 예: SelectKBest, f_classif
   - 장점: 계산이 빠르고 과적합에 덜 민감
   - 단점: 특성 간 상호작용을 고려하지 않음

2. **래퍼 방법(Wrapper Methods)**:
   - 예측 모델을 사용하여 특성 부분집합의 성능 평가
   - 예: RFE(Recursive Feature Elimination)
   - 장점: 특성 간 상호작용 고려, 보통 더 좋은 성능
   - 단점: 계산 비용이 높고 과적합 위험 있음

3. **내장 방법(Embedded Methods)**:
   - 특성 선택이 학습 과정에 통합됨
   - 예: L1 규제(Lasso) 사용한 선형 모델
   - 장점: 계산 효율성, 래퍼보다 과적합 위험 낮음
   - 단점: 모델에 따라 선택된 특성이 다를 수 있음

## 채점 기준
- 각 문제는 10점 만점이며, 총점은 100점입니다.
- 객관식 문제는 정답을 맞힐 경우 만점, 틀릴 경우 0점입니다.
- 코드 완성 및 오류 찾기 문제는 기능적으로 올바른 해결책을 제시할 경우 만점입니다.
- 주관식 문제는 핵심 개념을 올바르게 설명하고 적절한 예시를 제시할 경우 만점입니다. 