# 퀴즈: 데이터 시각화 도구 (Matplotlib, Seaborn)

## 기본 정보
- **제목**: 데이터 시각화 라이브러리 퀴즈
- **관련 섹션**: 파트 3-4 (데이터 시각화)
- **난이도**: 중
- **예상 소요 시간**: 15분

## 문제

### 1. Matplotlib 기본 요소 (10점)
Matplotlib에서 그림(Figure), 축(Axes), 그리고 축척(Axis)의 관계를 바르게 설명한 것은?
1. 하나의 Figure는 여러 개의 Axes를 포함하고, 각 Axes는 x축과 y축의 Axis를 가진다
2. 하나의 Axes는 여러 개의 Figure를 포함하고, 각 Figure는 x축과 y축의 Axis를 가진다
3. Figure와 Axes는 동일한 개념이며, 둘 다 Axis를 포함한다
4. Axis는 Figure를 포함하고, Figure는 여러 개의 Axes를 포함한다

**정답**: 1

### 2. 선 그래프 생성 (10점)
Matplotlib을 사용하여 기본 선 그래프를 생성하는 가장 일반적인 방법은?
1. `plt.line(x, y)`
2. `plt.plot(x, y)`
3. `plt.graph(x, y)`
4. `plt.draw(x, y)`

**정답**: 2

### 3. 그래프 스타일 지정 (10점)
다음 Matplotlib 코드의 출력 결과는 어떤 모양의 선을 그리나요?
```python
import matplotlib.pyplot as plt
plt.plot([1, 2, 3, 4], [1, 4, 9, 16], 'ro--')
```

1. 빨간색 점선
2. 빨간색 원형 마커와 점선
3. 빨간색 원형 마커
4. 빨간색 직선

**정답**: 2

### 4. Seaborn과 Matplotlib (10점)
Seaborn과 Matplotlib의 관계에 대한 올바른 설명은?
1. Seaborn은 Matplotlib를 완전히 대체하기 위해 설계되었다
2. Seaborn은 Matplotlib의 하위 라이브러리이다
3. Seaborn은 Matplotlib 위에 구축된 고수준 인터페이스로, 더 매력적인 기본 스타일과 복잡한 시각화를 위한 높은 수준의 추상화를 제공한다
4. Matplotlib과 Seaborn은 완전히 독립적인 별개의 라이브러리이다

**정답**: 3

### 5. 그래프 종류 선택 (10점)
범주형 변수와 연속형 변수 간의 관계를 보여주기 위한 가장 적절한 Seaborn 그래프는?
1. 히스토그램 (histplot)
2. 산점도 (scatterplot)
3. 바이올린 플롯 (violinplot)
4. 히트맵 (heatmap)

**정답**: 3

### 6. 다변량 데이터 시각화 (10점)
Seaborn에서 여러 숫자 변수 간의 상관관계를 한 번에 시각화하는 데 가장 적합한 함수는?
1. `sns.lineplot()`
2. `sns.scatterplot()`
3. `sns.pairplot()`
4. `sns.countplot()`

**정답**: 3

### 7. 그래프 커스터마이징 (10점)
Matplotlib에서 그래프의 제목, x축 레이블, y축 레이블을 설정하는 올바른 코드 순서는?
1. ```
   plt.xlabel('X값')
   plt.ylabel('Y값')
   plt.title('그래프 제목')
   ```
   
2. ```
   plt.title('그래프 제목')
   plt.xlabel('X값')
   plt.ylabel('Y값')
   ```
   
3. 둘 다 올바르다

4. 둘 다 틀리다

**정답**: 3

### 8. 코드 완성 (10점)
다음 코드를 완성하여 주어진 데이터에 대한 막대 그래프를 생성하고 제목과 축 레이블을 추가하세요.

```python
import matplotlib.pyplot as plt

def create_bar_chart(categories, values):
    # 코드를 작성하세요
    __________
    __________
    __________
    __________
    plt.show()

# 예시 사용:
# categories = ['A', 'B', 'C', 'D']
# values = [15, 24, 18, 30]
# create_bar_chart(categories, values)
```

**정답**:
```python
import matplotlib.pyplot as plt

def create_bar_chart(categories, values):
    plt.bar(categories, values)
    plt.title('카테고리별 값 분포')
    plt.xlabel('카테고리')
    plt.ylabel('값')
    plt.show()
```

### 9. 오류 찾기 (10점)
다음 코드에 오류가 있다면 찾아내고 수정하세요.
```python
import matplotlib.pyplot as plt
import numpy as np

x = np.linspace(0, 10, 100)
y = np.sin(x)

plt.figure()
plt.plot(x, y)
plt.savefig('sine_wave.png')
plt.title('사인파')
plt.show()
```

**정답**: `plt.title('사인파')`는 `plt.savefig('sine_wave.png')` 전에 와야 합니다. 저장된 이미지에 제목이 포함되지 않을 것입니다.

```python
import matplotlib.pyplot as plt
import numpy as np

x = np.linspace(0, 10, 100)
y = np.sin(x)

plt.figure()
plt.plot(x, y)
plt.title('사인파')
plt.savefig('sine_wave.png')
plt.show()
```

### 10. 주관식 (10점)
Seaborn의 `FacetGrid`의 목적과 사용 사례를 설명하세요.

**정답 예시**: 
Seaborn의 `FacetGrid`는 데이터셋의 하위 집합들로 플롯의 그리드(격자)를 만들기 위한 다중 패널 그리드입니다. 주요 목적은 하나 또는 두 개의 변수에 따라 데이터를 분할하여 동일한 종류의 플롯을 여러 서브셋에 적용하는 것입니다.

예시 사용 사례:
- 범주형 변수로 데이터를 나누어 각 범주별 분포를 비교할 때
- 시간에 따른 여러 그룹의 트렌드를 별도의 패널로 표시할 때
- 성별, 연령대 등 서로 다른 인구통계학적 그룹 간의 관계를 시각화할 때

```python
g = sns.FacetGrid(data=df, col="category", row="gender")
g.map(plt.scatter, "age", "income")
```

위 코드는 범주와 성별에 따라 나눈 서브플롯에 나이와 소득 간의 산점도를 그립니다.

## 채점 기준
- 각 문제는 10점 만점이며, 총점은 100점입니다.
- 객관식 문제는 정답을 맞힐 경우 만점, 틀릴 경우 0점입니다.
- 코드 완성 및 오류 찾기 문제는 기능적으로 올바른 해결책을 제시할 경우 만점입니다.
- 주관식 문제는 핵심 개념을 올바르게 설명하고 적절한 예시를 제시할 경우 만점입니다. 