# 퀴즈: 데이터 분석 기초 (Numpy, Pandas)

## 기본 정보
- **제목**: 데이터 분석 라이브러리 기초 퀴즈
- **관련 섹션**: 파트 2-3 (데이터 분석 기초)
- **난이도**: 중
- **예상 소요 시간**: 15분

## 문제

### 1. NumPy 배열 생성 (10점)
다음 중 NumPy를 사용하여 0부터 20까지의 짝수로 이루어진 배열을 생성하는 올바른 코드는 무엇인가요?
1. `np.array(range(0, 21, 2))`
2. `np.arange(0, 21, 2)`
3. `np.linspace(0, 20, 11)`
4. `np.zeros(10) + np.arange(0, 20, 2)`

**정답**: 2

### 2. NumPy 배열 연산 (10점)
다음 코드의 출력 결과는 무엇인가요?
```python
import numpy as np
a = np.array([1, 2, 3])
b = np.array([4, 5, 6])
print(a * b)
```

**정답**: `[ 4 10 18]`

### 3. NumPy 차원 변환 (10점)
다음 코드의 실행 결과로 생성되는 배열의 shape은 무엇인가요?
```python
import numpy as np
arr = np.arange(12)
arr = arr.reshape(3, 4)
```

**정답**: `(3, 4)`

### 4. Pandas Series (10점)
다음 Pandas 코드의 출력 결과는 무엇인가요?
```python
import pandas as pd
s = pd.Series([1, 2, 3, 4], index=['a', 'b', 'c', 'd'])
print(s[s > 2])
```

**정답**: 
```
c    3
d    4
dtype: int64
```

### 5. Pandas DataFrame (10점)
다음 코드의 실행 결과로 생성되는 DataFrame의 모양(shape)은 무엇인가요?
```python
import pandas as pd
df = pd.DataFrame({
    'A': [1, 2, 3],
    'B': [4, 5, 6],
    'C': [7, 8, 9]
})
```

**정답**: `(3, 3)`

### 6. 데이터 필터링 (10점)
다음 중 Pandas에서 DataFrame `df`의 'Age' 열이 30 이상이고 'Salary' 열이 50000 이상인 행을 선택하는 올바른 방법은 무엇인가요?
1. `df[df['Age'] >= 30 and df['Salary'] >= 50000]`
2. `df.where(df['Age'] >= 30 & df['Salary'] >= 50000)`
3. `df[(df['Age'] >= 30) & (df['Salary'] >= 50000)]`
4. `df.query('Age >= 30 & Salary >= 50000')`

**정답**: 3과 4 모두 정답 (두 가지 방법 다 가능)

### 7. 결측치 처리 (10점)
Pandas DataFrame에서 결측치(NaN)를 처리하는 메소드가 아닌 것은?
1. `dropna()`
2. `fillna()`
3. `isna()`
4. `removeNull()`

**정답**: 4

### 8. 코드 완성 (10점)
다음 코드를 완성하여 주어진 DataFrame의 'score' 열의 평균, 중앙값, 표준편차를 계산하세요.
```python
import pandas as pd

def analyze_scores(df):
    # 코드를 작성하세요
    __________
    __________
    __________
    return mean_score, median_score, std_score

# 예시 사용:
# df = pd.DataFrame({'name': ['A', 'B', 'C'], 'score': [85, 90, 78]})
# mean, median, std = analyze_scores(df)
```

**정답**:
```python
import pandas as pd

def analyze_scores(df):
    mean_score = df['score'].mean()
    median_score = df['score'].median()
    std_score = df['score'].std()
    return mean_score, median_score, std_score
```

### 9. 오류 찾기 (10점)
다음 코드에 오류가 있다면 찾아내고 수정하세요.
```python
import pandas as pd
data = {'name': ['Alice', 'Bob', 'Charlie', 'David'],
        'age': [25, 30, 35, 40],
        'city': ['New York', 'Paris', 'London', 'Tokyo']}
df = pd.DataFrame(data)
result = df.groupby('age').sum()
print(result)
```

**정답**: 'age'로 그룹화한 후 sum()을 적용하는데, 'name'과 'city' 열은 문자열이므로 합산할 수 없습니다. 숫자 데이터가 있는 열만 선택하거나, 집계 함수를 수정해야 합니다.
```python
result = df.groupby('age').size()  # 각 나이별 개수를 계산
# 또는
result = df.groupby('age')['name'].count()  # 각 나이별 이름 개수를 계산
```

### 10. 주관식 (10점)
Pandas에서 두 개의 DataFrame을 병합(merge)하는 방법에는 어떤 종류가 있으며, 각각 SQL의 어떤 조인(join) 유형에 해당하는지 설명하세요.

**정답 예시**:
Pandas에서 DataFrame 병합 방법:
1. `inner`: 양쪽 DataFrame에 모두 있는 키만 유지 (SQL의 INNER JOIN)
2. `left`: 왼쪽 DataFrame의 모든 키를 유지 (SQL의 LEFT JOIN)
3. `right`: 오른쪽 DataFrame의 모든 키를 유지 (SQL의 RIGHT JOIN)
4. `outer`: 양쪽 DataFrame의 모든 키를 유지 (SQL의 FULL OUTER JOIN)

예: `pd.merge(df1, df2, on='key', how='inner')`

## 채점 기준
- 각 문제는 10점 만점이며, 총점은 100점입니다.
- 객관식 문제는 정답을 맞힐 경우 만점, 틀릴 경우 0점입니다.
- 코드 완성 및 오류 찾기 문제는 기능적으로 올바른 해결책을 제시할 경우 만점입니다.
- 주관식 문제는 핵심 개념을 올바르게 설명하고 적절한 예시를 제시할 경우 만점입니다. 