import requests
import json
import os
import sys

# API 엔드포인트
API_URL = "http://localhost:8002"

def read_sample_code(filename):
    """샘플 코드 파일을 읽어옵니다."""
    file_path = os.path.join("test_samples", filename)
    with open(file_path, "r") as file:
        return file.read()

def submit_code(user_id, assignment_id, code):
    """코드를 제출하고 평가 결과를 받아옵니다."""
    url = f"{API_URL}/submit"
    data = {
        "user_id": user_id,
        "assignment_id": assignment_id,
        "code": code
    }
    
    response = requests.post(url, json=data)
    if response.status_code == 200:
        return response.json()
    else:
        print(f"오류: {response.status_code}")
        print(response.text)
        return None

def get_result(submission_id):
    """제출된 코드의 평가 결과를 조회합니다."""
    url = f"{API_URL}/result/{submission_id}"
    response = requests.get(url)
    
    if response.status_code == 200:
        return response.json()
    else:
        print(f"오류: {response.status_code}")
        print(response.text)
        return None

def main():
    """테스트 실행 함수"""
    # 샘플 코드 읽기
    try:
        sample_code = read_sample_code("square.py")
    except Exception as e:
        print(f"샘플 코드 읽기 실패: {e}")
        return
    
    # 코드 제출 및 평가
    print("코드 평가 시스템 API 테스트 시작...")
    result = submit_code("test_user", "assignment1", sample_code)
    
    if result:
        # 결과 출력
        print("\n===== 평가 결과 =====")
        print(f"제출 ID: {result['submission_id']}")
        print(f"타임스탬프: {result['timestamp']}")
        print("\n-- 테스트 결과 --")
        for test_name, test_data in result['test_results'].items():
            status = "통과" if test_data['passed'] else "실패"
            print(f"{test_name}: {status}")
            if not test_data['passed']:
                print(f"  입력값: {test_data['input']}")
                print(f"  기대 출력: {test_data['expected']}")
                print(f"  실제 출력: {test_data['actual']}")
        
        print("\n-- 스타일 분석 --")
        print(f"스타일 점수: {result['style_analysis']['score']}/10")
        if result['style_analysis']['issues']:
            print("주요 스타일 이슈:")
            for issue in result['style_analysis']['issues'][:3]:
                print(f"  라인 {issue['line']}: {issue['message']}")
        
        print("\n-- 피드백 --")
        print(result['feedback'])
        
        print(f"\n최종 점수: {result['score']}/10")
    
    print("\n테스트 완료")

if __name__ == "__main__":
    main() 