# 자동 코드 평가 시스템 프로토타입

이 프로젝트는 학습자가 제출한 코드를 자동으로 평가하고 즉각적인 피드백을 제공하는 시스템의 프로토타입입니다. Python 코드를 안전하게 실행하고 테스트 케이스를 검증하며 코드 스타일을 분석합니다.

## 주요 기능

- Python 코드 실행 및 테스트 케이스 검증
- 코드 품질 및 스타일 분석 (pylint 사용)
- 종합적인 피드백 및 점수 제공
- 웹 기반 코드 제출 및 결과 확인 인터페이스

## 시스템 구성

- **백엔드**: FastAPI를 사용한 RESTful API
- **프론트엔드**: HTML, CSS, JavaScript (Bootstrap, Ace Editor)
- **코드 평가**: Python의 기본 라이브러리와 Pylint를 활용

## 설치 및 실행 방법

### 요구사항

- Python 3.8 이상
- pip (Python 패키지 관리자)

### 설치

1. 프로젝트 클론 또는 다운로드

2. 필요 패키지 설치
```bash
pip install -r requirements.txt
```

### 실행

```bash
python main.py
```

서버가 시작되면 웹 브라우저에서 `http://localhost:8000`으로 접속하여 시스템을 사용할 수 있습니다.

## API 엔드포인트

- **POST /submit**: 코드 제출 및 평가
  - 요청 본문: `user_id`, `assignment_id`, `code`
  - 응답: 테스트 결과, 스타일 분석, 피드백, 점수

- **GET /result/{submission_id}**: 제출 결과 조회

## 프로토타입 한계 및 향후 개선 사항

- 현재는 Python 코드만 지원
- 보안 강화 필요 (Docker 컨테이너 등을 활용)
- 다양한 프로그래밍 언어 지원 확장
- 데이터베이스 연동을 통한 학습자 진행 상황 추적
- 기계학습 기반 코드 분석 및 개인화된 피드백 