# AI 전문가 과정 실습 소스코드

이 디렉토리에는 AI 전문가 양성 과정의 각 파트별 실습 소스코드가 포함되어 있습니다.

## 🗂 디렉토리 구조

각 디렉토리는 강의 파트 번호에 맞춰 구성되어 있습니다.

- `02_python_core_syntax/`: 파이썬 핵심 문법 실습 스크립트
- `03_python_collections/`: 파이썬 컬렉션 활용 실습 스크립트
- `04_object_oriented_programming/`: 객체 지향 프로그래밍 실습 스크립트
- `05_ai_core_libraries/`: NumPy, Pandas 등 AI 핵심 라이브러리 실습 스크립트
- `06_machine_learning/`: Scikit-learn을 이용한 머신러닝 모델링 실습 스크립트
- `07_deep_learning/`: PyTorch를 이용한 딥러닝 모델링 실습 코드
- `08_model_serving_with_fastapi/`: FastAPI를 이용한 간단한 모델 서빙 API
- `09_production_ready_api/`: 실제 프로덕션 환경에 가까운 구조를 갖춘 FastAPI 프로젝트
- `11_mlops/`: MLOps 파이프라인 관련 실습 코드 (Kubeflow, GitHub Actions 등)
- `12_model_optimization/`: 모델 경량화 및 최적화 관련 실습 코드
- `13_generative_ai/`: LangChain, RAG, Agent 등 생성 AI 애플리케이션 실습 코드
- `14_ai_ethics/`: AI 윤리 관련 도구(Fairlearn, SHAP) 실습 코드

## ⚙️ 환경 설정 및 실행

각 파트별로 필요한 라이브러리가 다를 수 있습니다. 특정 파트의 코드를 실행하기 전, 해당 디렉토리 내에 `requirements.txt` 파일이 있는지 확인하고, 아래와 같이 가상환경에 필요한 라이브러리를 설치하는 것을 권장합니다.

```bash
# 예시: 08_model_serving_with_fastapi 파트 실습 준비
# 1. 해당 디렉토리로 이동
cd 08_model_serving_with_fastapi

# 2. (가상환경 활성화 상태에서) 필요 라이브러리 설치
pip install -r requirements.txt

# 3. main.py 실행 (Uvicorn 이용)
uvicorn main:app --reload
```

만약 `requirements.txt` 파일이 없는 간단한 스크립트의 경우, 전역적으로 설치된 `numpy`, `pandas`, `scikit-learn`, `torch` 등의 라이브러리를 사용합니다. 과정 초반에 안내된 [개발 환경 설정 가이드](./../courses/01_ai_development_environment/part_1_ai_development_environment.md)를 참고하여 기본 라이브러리를 설치해주세요.

> [!TIP]
> 각 파트별로 별도의 가상환경을 구성하여 관리하면 의존성 충돌 문제를 피할 수 있어 더욱 좋습니다. 