# Part 15: AI 전문가 양성 과정 캡스톤 프로젝트

## 📋 개요

이 모듈은 AI 전문가 양성 과정의 최종 프로젝트를 위한 기본 구조와 핵심 기능들을 제공합니다. 학습자들이 실제 AI 프로젝트를 완성하고 포트폴리오를 작성할 수 있도록 도와줍니다.

## 🎯 주요 기능

### 1. 프로젝트 템플릿 생성 (`CapstoneProject`)
- 표준화된 프로젝트 디렉토리 구조 생성
- 프로젝트 설정 파일 자동 생성
- README.md 템플릿 제공

### 2. 모델 평가 및 성능 측정 (`ModelEvaluator`)
- 분류 모델 평가 (정확도, 정밀도, 재현율, F1-score)
- 회귀 모델 평가 (MSE, RMSE, MAE, R²-score)
- HTML 형태의 평가 리포트 생성

### 3. 포트폴리오 작성 가이드 (`PortfolioGenerator`)
- 개인 포트폴리오 HTML 생성
- 기술 스킬 및 프로젝트 정보 관리
- 반응형 웹 디자인 적용

## 🚀 사용 방법

### 기본 사용법

```python
from part_15_capstone_project import CapstoneProject, ModelEvaluator, PortfolioGenerator

# 1. 프로젝트 생성
project = CapstoneProject("my_ai_project", "ml")
project.create_project_structure()

# 2. 모델 평가
evaluator = ModelEvaluator()
metrics = evaluator.evaluate_classification(y_true, y_pred)
evaluator.generate_report("evaluation_report.html")

# 3. 포트폴리오 생성
portfolio = PortfolioGenerator("홍길동")
portfolio.add_skill("Python", "Advanced")
portfolio.add_project({
    "name": "감정 분석 모델",
    "description": "텍스트 기반 감정 분석 모델 개발",
    "technologies": "Python, TensorFlow, FastAPI",
    "results": "정확도 85% 달성"
})
portfolio.generate_portfolio("portfolio.html")
```

### 프로젝트 타입

지원하는 프로젝트 타입:
- `ml`: 머신러닝 프로젝트
- `nlp`: 자연어처리 프로젝트
- `cv`: 컴퓨터 비전 프로젝트
- `rl`: 강화학습 프로젝트

## 📁 생성되는 디렉토리 구조

```
my_ai_project/
├── data/           # 데이터 파일
├── models/         # 훈련된 모델
├── src/           # 소스 코드
├── tests/         # 테스트 코드
├── docs/          # 문서
├── notebooks/     # Jupyter 노트북
├── scripts/       # 유틸리티 스크립트
├── config/        # 설정 파일
│   └── project_config.json
└── README.md      # 프로젝트 설명서
```

## 🧪 테스트

테스트를 실행하려면:

```bash
cd ai_lecture/source_code/15_capstone_project/tests
python test_part_15.py
```

### 테스트 커버리지

- **CapstoneProject 클래스**: 프로젝트 생성, 설정 관리, 디렉토리 구조 생성
- **ModelEvaluator 클래스**: 모델 평가, 메트릭 계산, 리포트 생성
- **PortfolioGenerator 클래스**: 포트폴리오 생성, 스킬/프로젝트 관리
- **통합 테스트**: 전체 워크플로우 테스트
- **에러 처리**: 예외 상황 처리 테스트

## 📊 예제 프로젝트

### 1. 감정 분석 모델

```python
# 프로젝트 생성
project = CapstoneProject("sentiment_analysis", "nlp")
project.create_project_structure()

# 모델 평가
evaluator = ModelEvaluator()
metrics = evaluator.evaluate_classification(y_true, y_pred)
print(f"정확도: {metrics['accuracy']:.4f}")
print(f"F1-score: {metrics['f1_score']:.4f}")

# 포트폴리오에 추가
portfolio = PortfolioGenerator("학습자")
portfolio.add_project({
    "name": "감정 분석 모델",
    "description": "텍스트 기반 감정 분석 모델 개발",
    "technologies": "Python, TensorFlow, FastAPI",
    "results": f"정확도 {metrics['accuracy']:.1%} 달성"
})
```

### 2. 이미지 분류 모델

```python
# 프로젝트 생성
project = CapstoneProject("image_classification", "cv")
project.create_project_structure()

# 모델 평가
evaluator = ModelEvaluator()
metrics = evaluator.evaluate_classification(y_true, y_pred)
evaluator.generate_report("image_classification_report.html")
```

## 🔧 의존성

필요한 패키지:
- `numpy`: 수치 계산
- `pandas`: 데이터 처리
- `scikit-learn`: 머신러닝 메트릭
- `plotly`: 시각화 (선택사항)

설치:
```bash
pip install numpy pandas scikit-learn plotly
```

## 📝 포트폴리오 작성 가이드

### 1. 기술 스킬 추가

```python
portfolio = PortfolioGenerator("학습자")

# 기술 스킬 추가
portfolio.add_skill("Python", "Advanced")
portfolio.add_skill("Machine Learning", "Intermediate")
portfolio.add_skill("Deep Learning", "Intermediate")
portfolio.add_skill("FastAPI", "Intermediate")
portfolio.add_skill("Docker", "Beginner")
```

### 2. 프로젝트 정보 추가

```python
# 프로젝트 정보 추가
portfolio.add_project({
    "name": "감정 분석 모델",
    "description": "텍스트 기반 감정 분석 모델 개발",
    "technologies": "Python, TensorFlow, FastAPI",
    "results": "정확도 85% 달성"
})

portfolio.add_project({
    "name": "이미지 분류 시스템",
    "description": "CNN을 활용한 이미지 분류 시스템",
    "technologies": "Python, PyTorch, OpenCV",
    "results": "정확도 92% 달성"
})
```

### 3. 포트폴리오 생성

```python
# HTML 포트폴리오 생성
portfolio.generate_portfolio("my_portfolio.html")
```

## 🎨 생성되는 포트폴리오 특징

- **반응형 디자인**: 모바일/데스크톱 호환
- **모던 UI**: 그라데이션 배경, 카드 레이아웃
- **한국어 지원**: UTF-8 인코딩
- **시각적 요소**: 스킬 태그, 프로젝트 카드

## 🔍 모니터링 및 로깅

모듈은 상세한 로깅을 제공합니다:

```python
import logging
logging.basicConfig(level=logging.INFO)

# 로그 확인
# INFO:part_15_capstone_project:프로젝트 구조가 성공적으로 생성되었습니다: projects/my_ai_project
# INFO:part_15_capstone_project:평가 리포트가 생성되었습니다: evaluation_report.html
# INFO:part_15_capstone_project:포트폴리오가 생성되었습니다: portfolio.html
```

## 🚨 주의사항

1. **의존성 관리**: 필요한 패키지가 설치되어 있는지 확인
2. **파일 권한**: 프로젝트 디렉토리 생성 시 적절한 권한 필요
3. **메모리 사용**: 대용량 데이터 처리 시 메모리 사용량 주의
4. **보안**: 생성된 파일의 보안 설정 확인

## 🤝 기여 방법

1. 이슈 등록: 버그 리포트 또는 기능 요청
2. 브랜치 생성: 새로운 기능 개발
3. 테스트 작성: 새로운 기능에 대한 테스트 추가
4. 풀 리퀘스트: 코드 리뷰 후 병합

## 📞 지원

- **기술적 이슈**: GitHub Issues
- **일반 문의**: geumdo@geumdo.net
- **문서 개선**: README.md 수정 제안

## 📄 라이선스

MIT License

---

*AI 전문가 양성 과정 - Part 15: 캡스톤 프로젝트* 