# Part 14: AI 윤리 실습 코드

이 디렉토리에는 AI의 윤리적 측면을 다루는 책임감 있는 AI (Responsible AI) 기술 예제 코드가 포함되어 있습니다.

- `bias_detection_mitigation.py`: Fairlearn 라이브러리를 사용하여 머신러닝 모델의 편향을 탐지하고 완화하는 방법을 보여줍니다.
- `xai_report_generator.py`: LIME, SHAP과 같은 설명가능 AI (XAI) 기술을 사용하여 모델의 예측을 설명하고, 보고서를 생성하는 방법을 시연합니다.

## 🚀 실행 방법

### 1. 의존성 설치

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 아직 설치하지 않았다면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

### 2. 스크립트 실행

각 스크립트는 터미널에서 직접 실행하여 AI 윤리 관련 기술의 작동 방식을 확인할 수 있습니다.

```bash
# 편향 탐지 및 완화 스크립트 실행
python bias_detection_mitigation.py

# XAI 보고서 생성 스크립트 실행
python xai_report_generator.py
``` 