# Part 13: 생성형 AI 실습 코드

이 디렉토리에는 LangChain, LangGraph 및 관련 라이브러리를 사용하여 구축된 고급 생성형 AI 애플리케이션 예제 코드가 포함되어 있습니다.

- `advanced_rag_chatbot.py`: 하이브리드 검색, 쿼리 변환, 재순위화 등 고급 RAG(Retrieval-Augmented Generation) 기술을 활용한 챗봇을 구현하는 방법을 보여줍니다.
- `autonomous_agent.py`: LangGraph를 사용하여 스스로 추론하고 도구를 사용하는 자율 에이전트를 구축하는 예제입니다.
- `langsmith_tracing_debugging.py`: LangSmith를 사용하여 LLM 애플리케이션의 실행 과정을 추적하고 디버깅하는 방법을 시연합니다.
- `multi_agent_collaboration.py`: 여러 전문가 에이전트(프로젝트 매니저, 데이터 사이언티스트, 알고리즘 전문가, 기술 작가)가 협업하여 복잡한 문제를 해결하는 멀티에이전트 시스템을 구현한 예제입니다.
- `contextual_compression_rag.py`: 검색된 문서에서 불필요한 내용을 제거하고 사용자 질문과 관련된 핵심 내용만 추출하는 문맥 압축 기법을 적용한 RAG 시스템입니다.

## 🚀 실행 방법

### 1. 의존성 설치

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 아직 설치하지 않았다면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

### 2. 환경 변수 설정

LangChain, OpenAI, LangSmith, Tavily AI 등을 사용하기 위해서는 API 키 설정이 필요합니다. 프로젝트 루트에 `.env` 파일을 생성하고 아래와 같이 키를 입력하세요.

```
# .env 파일 예시
OPENAI_API_KEY="sk-..."
LANGCHAIN_API_KEY="..."
TAVILY_API_KEY="..."

# LangSmith 추적을 활성화하려면 아래 변수를 설정하세요
LANGCHAIN_TRACING_V2="true"
LANGCHAIN_PROJECT="My Generative AI Project"
```

### 3. 스크립트 실행

각 스크립트는 터미널에서 직접 실행하여 생성형 AI 애플리케이션의 작동을 확인할 수 있습니다.

```bash
# 고급 RAG 챗봇 실행
python advanced_rag_chatbot.py

# 자율 에이전트 실행
python autonomous_agent.py

# LangSmith 추적 및 디버깅 예제 실행
python langsmith_tracing_debugging.py

# 멀티에이전트 협업 시스템 실행
python multi_agent_collaboration.py

# 문맥 압축 RAG 시스템 실행
python contextual_compression_rag.py
``` 