# Part 12: 모델 최적화 실습 코드

이 디렉토리에는 딥러닝 모델의 성능을 향상시키기 위한 최적화 기술 예제 코드가 포함되어 있습니다.

- `bert_quantization.py`: Hugging Face Transformers 라이브러리의 BERT 모델을 양자화(Quantization)하여 모델의 크기를 줄이고 추론 속도를 높이는 방법을 보여줍니다.
- `triton_migration_benchmark.py`: 최적화된 모델을 NVIDIA Triton Inference Server로 마이그레이션하고 성능을 벤치마킹하는 과정을 시연합니다.

## 🚀 실행 방법

### 1. 의존성 설치

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 아직 설치하지 않았다면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

### 2. 스크립트 실행

각 스크립트는 터미널에서 직접 실행하여 모델 최적화 과정을 확인할 수 있습니다.

```bash
# BERT 모델 양자화 실행
python bert_quantization.py

# Triton 마이그레이션 및 벤치마크 실행
# (로컬에 Triton 서버가 실행 중이어야 합니다)
python triton_migration_benchmark.py
```

**참고:** `triton_migration_benchmark.py`를 실행하기 위해서는 NVIDIA Triton Inference Server가 설치되고 실행 중인 환경이 필요합니다. 