# Part 11: MLOps 실습 코드

이 디렉토리에는 MLOps 파이프라인의 다양한 구성 요소를 시연하는 Python 스크립트와 설정 파일이 포함되어 있습니다.

- `feature_store_pipeline.py`: Feast를 사용한 피처 스토어 파이프라인 예제입니다.
- `conditional_pipeline.py`: Kubeflow 등에서 사용될 수 있는 조건부 파이프라인 로직 예제입니다.
- `data_drift_detection.py`: Evidently AI를 사용한 데이터 드리프트 감지 스크립트입니다.
- `ab_test_cd_workflow.yml`: GitHub Actions를 이용한 A/B 테스트 및 지속적 배포(CD) 워크플로우 예제입니다.

## 🚀 실행 방법

### 1. 의존성 설치

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 아직 설치하지 않았다면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

### 2. 스크립트 실행

각 Python 스크립트는 특정 MLOps 개념을 독립적으로 보여주도록 설계되었습니다. 터미널에서 직접 실행하여 각 기능을 확인할 수 있습니다.

```bash
# 예: 데이터 드리프트 감지 스크립트 실행
python data_drift_detection.py

# 예: 피처 스토어 파이프라인 실행
python feature_store_pipeline.py
```

`ab_test_cd_workflow.yml` 파일은 GitHub Actions 워크플로우이므로, `.github/workflows/` 디렉토리에 위치시켜야 GitHub 리포지토리에서 자동으로 실행됩니다. 