# app/schemas.py
from typing import List, Optional

from pydantic import BaseModel


class IrisInput(BaseModel):
    sepal_length: float
    sepal_width: float
    petal_length: float
    petal_width: float

    class Config:
        json_schema_extra = {
            "example": {
                "sepal_length": 5.1,
                "sepal_width": 3.5,
                "petal_length": 1.4,
                "petal_width": 0.2,
            }
        }


class IrisPrediction(BaseModel):
    species_name: str
    prediction: int


class ModelInfo(BaseModel):
    name: str
    version: str
    description: str
