# app/main.py

import uvicorn
from fastapi import FastAPI

from . import api

app = FastAPI(
    title="Production-Ready AI Model API",
    description="A production-ready API for serving ML models using FastAPI and Docker.",
    version="2.0.0",
)


@app.get("/")
async def root():
    return {
        "message": "Welcome to the Production-Ready AI API. See /docs for documentation."
    }


app.include_router(api.router, prefix="/api/v1", tags=["Iris Prediction"])

# Note: The uvicorn.run() part is typically removed for production,
# as the server will be started by a process manager like Gunicorn or Uvicorn directly
# from the command line, as defined in the Dockerfile.
# We keep it here for consistency in the course material.
if __name__ == "__main__":
    uvicorn.run("app.main:app", host="0.0.0.0", port=8000, reload=True)
