# Part 9: 프로덕션 레벨 API 실습 코드

이 디렉토리에는 프로덕션 환경에 배포 가능한 수준의 구조를 갖춘 FastAPI 애플리케이션 예제 코드가 포함되어 있습니다. `app` 디렉토리 안에 실제 애플리케이션 코드가 있으며, Docker를 이용한 배포를 위한 `Dockerfile`과 `docker-compose.yml`이 포함되어 있습니다.

## 🚀 실행 방법

### 1. 의존성 설치 (로컬 실행 시)

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 로컬에서 직접 서버를 실행하려면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

이후 다음 명령어로 서버를 실행할 수 있습니다.

```bash
uvicorn app.main:app --reload --cwd ./source_code/09_production_ready_api
```

### 2. Docker를 이용한 실행 (권장)

이 파트의 주 목적은 Docker를 이용한 컨테이너화입니다. Docker가 설치되어 있다면 다음 명령어로 간단하게 전체 서비스를 빌드하고 실행할 수 있습니다.

이 디렉토리(`source_code/09_production_ready_api`)에서 다음 명령어를 실행하세요.

```bash
docker-compose up --build
```

### 3. API 문서 확인

서버가 실행되면, 웹 브라우저에서 다음 주소로 접속하여 자동 생성된 API 문서를 확인하고 테스트할 수 있습니다.

- [http://127.0.0.1:8000/docs](http://127.0.0.1:8000/docs) 