# schemas.py
# API의 요청(Request) 및 응답(Response) 데이터 형식을 정의합니다.

from typing import List, Optional

from pydantic import BaseModel


class IrisInput(BaseModel):
    """붓꽃 예측을 위한 입력 데이터 형식"""

    sepal_length: float
    sepal_width: float
    petal_length: float
    petal_width: float

    class Config:
        # Pydantic 모델이 API 문서에 예시로 보일 때 사용될 값
        json_schema_extra = {
            "example": {
                "sepal_length": 5.1,
                "sepal_width": 3.5,
                "petal_length": 1.4,
                "petal_width": 0.2,
            }
        }


class IrisPrediction(BaseModel):
    """붓꽃 예측 결과 형식"""

    species_name: str
    prediction: int


class ModelInfo(BaseModel):
    """현재 로드된 모델의 정보를 담는 형식"""

    name: str
    version: str
    description: str
