# main.py
# FastAPI 애플리케이션을 생성하고, 라우터를 포함시켜 서버를 실행하는 진입점입니다.

import uvicorn
from fastapi import FastAPI

import api  # api.py에서 정의한 라우터를 임포트

# FastAPI 앱 인스턴스 생성
app = FastAPI(
    title="AI 모델 서빙 API",
    description="머신러닝 모델을 서빙하기 위한 FastAPI 기반 API입니다.",
    version="1.0.0",
)


# 루트 경로
@app.get("/")
async def root():
    return {
        "message": "AI 모델 서빙 API에 오신 것을 환영합니다. /docs 로 이동하여 API 문서를 확인하세요."
    }


# api.py에서 정의한 라우터를 앱에 포함
# prefix="/api/v1"을 설정하여 모든 관련 엔드포인트가 이 경로 하위에 위치하도록 함
app.include_router(api.router, prefix="/api/v1", tags=["Iris Prediction"])

# 이 파일이 직접 실행될 때 uvicorn 서버를 시작합니다.
# 터미널에서 `python main.py`를 실행하거나,
# `uvicorn 08_model_serving_with_fastapi.main:app --reload` 명령어로 실행할 수 있습니다.
if __name__ == "__main__":
    uvicorn.run(
        "08_model_serving_with_fastapi.main:app", host="0.0.0.0", port=8000, reload=True
    )
