# Part 7: 딥러닝 - 실습 코드

이 디렉토리에는 AI 전문가 과정의 **Part 7: 딥러닝**에 해당하는 실습 코드가 포함되어 있습니다. 기본적인 딥러닝부터 고급 주제까지 다양한 신경망 아키텍처를 실습할 수 있습니다.

## 📁 파일 구조 및 설명

각 주제는 강의 및 대화형 실습을 위한 `.ipynb` 파일과, 코드 실행 및 테스트를 위한 `.py` 파일로 구성되어 있습니다.

- **`part_7_deep_learning.ipynb / .py`**: 기본적인 딥러닝 모델 (CNN, 이미지 분류)
- **`part_7.1_recurrent_neural_networks.ipynb / .py`**: LSTM, GRU를 활용한 순환 신경망과 시계열 데이터 예측
- **`part_7.2_transformer_and_llm_principles.ipynb / .py`**: Transformer 아키텍처와 Attention 메커니즘
- **`live_coding_transformer_from_scratch.py`**: (보너스) 의존성 없이 Transformer 블록을 밑바닥부터 구현하는 라이브 코딩용 스크립트
- **`7.3_llm_application_development_with_langchain/`**: LangChain을 활용한 LLM 애플리케이션 개발 (자세한 내용은 해당 디렉토리의 README 참조)
- **`part_7.4_graph_neural_networks.ipynb / .py`**: PyTorch Geometric을 사용한 그래프 신경망  
- **`part_7.5_reinforcement_learning.ipynb / .py`**: Q-Learning과 DQN을 활용한 강화학습 기초

## 🚀 실행 방법

### 1. 의존성 설치

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 아직 설치하지 않았다면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

### 2-1. Python 스크립트 실행

터미널에서 이 디렉토리로 이동한 후 원하는 Python 스크립트를 실행합니다:

```bash
cd "ai lecture/source_code/07_deep_learning"

# 기본 딥러닝 실습
python part_7_deep_learning.py

# RNN/LSTM 실습
python part_7.1_recurrent_neural_networks.py

# Transformer 실습
python part_7.2_transformer_and_llm_principles.py

# 그래프 신경망 실습
python part_7.4_graph_neural_networks.py

# 강화학습 실습
python part_7.5_reinforcement_learning.py
```

### 2-2. Jupyter 노트북 실행

Jupyter Lab 또는 Jupyter Notebook을 사용하여 인터랙티브하게 실습할 수 있습니다.

```bash
# Jupyter Lab 실행
jupyter lab

# 또는 Jupyter Notebook 실행
jupyter notebook
```
> Jupyter 환경에서 원하는 `.ipynb` 파일을 찾아 실행하세요.

## 📚 주요 실습 내용

### 7.0 기본 딥러닝
- **합성곱 신경망 (CNN)**: 이미지 분류를 위한 CNN 아키텍처 구현
- **모델 훈련**: 손실 함수, 옵티마이저, 학습률 스케줄링
- **성능 평가**: 정확도, 혼동 행렬, 분류 리포트

### 7.1 순환 신경망 (RNN)
- **LSTM (Long Short-Term Memory)**: 시계열 데이터를 위한 LSTM 네트워크
- **GRU (Gated Recurrent Unit)**: 더 간단한 순환 네트워크 구조
- **시계열 예측**: 주식 가격, 날씨 데이터 등을 활용한 예측 모델

### 7.2 Transformer & LLM 원리
- **Attention 메커니즘**: Multi-Head Attention 구현 및 시각화
- **Transformer 아키텍처**: Encoder-Decoder 구조 이해
- **위치 인코딩**: Positional Encoding 구현
- **간단한 언어 모델**: 작은 규모의 Transformer 기반 언어 모델

### 7.4 그래프 신경망 (GNN)
- **PyTorch Geometric**: 그래프 데이터 처리를 위한 라이브러리 사용
- **그래프 합성곱**: GCN (Graph Convolutional Network) 구현
- **노드 분류**: 그래프의 노드를 분류하는 작업
- **그래프 분류**: 전체 그래프를 분류하는 작업

### 7.5 강화학습
- **Q-Learning**: 테이블 기반 Q-Learning 알고리즘
- **DQN (Deep Q-Network)**: 신경망을 활용한 Q-Learning
- **OpenAI Gym**: 강화학습 환경에서의 에이전트 훈련
- **경험 재생**: Experience Replay를 통한 학습 안정화

## 🧪 테스트 실행

이 모듈에는 단위 테스트가 포함되어 있습니다. 테스트를 실행하려면:

```bash
# 프로젝트 루트에서 전체 테스트 실행
bash scripts/run_tests.sh

# 또는 이 모듈의 테스트만 실행
python -m pytest tests/test_part_7.py -v
```

## 💡 실습 팁

1. **GPU 가속**: CUDA가 설치된 환경에서는 GPU를 활용하여 더 빠른 학습이 가능합니다.
2. **시각화**: 각 실습에는 모델의 학습 과정과 결과를 시각화하는 코드가 포함되어 있습니다.
3. **하이퍼파라미터**: 다양한 하이퍼파라미터를 조정해보며 모델 성능 변화를 관찰해보세요.
4. **데이터셋**: 실습에 사용되는 데이터셋은 자동으로 다운로드되거나 synthetic data를 생성합니다.

## 🔗 관련 자료

- [PyTorch 공식 문서](https://pytorch.org/docs/)
- [PyTorch Geometric 문서](https://pytorch-geometric.readthedocs.io/)
- [OpenAI Gym 문서](https://gym.openai.com/)
- [Hugging Face Transformers](https://huggingface.co/docs/transformers/) 