# Part 6: 머신러닝 - 실습 코드

이 디렉토리에는 AI 전문가 과정의 **Part 6: 머신러닝**에 해당하는 실습 코드가 포함되어 있습니다.

## 파일 설명

- **`part_6_machine_learning.ipynb`**: 강의 내용과 함께 단계별 코드 실행이 가능한 주피터 노트북 파일입니다. 이론 설명과 코드 예제를 함께 보며 학습하는 데 사용됩니다.
- **`part_6_machine_learning.py`**: `.ipynb` 파일에서 순수 코드 부분만 추출한 파이썬 스크립트입니다. 전체 코드를 한 번에 실행하거나 코드 분석, 테스트 등의 목적으로 사용됩니다.

## 🚀 실행 방법

### 1. 의존성 설치

모든 필수 라이브러리는 프로젝트 루트의 `requirements.txt` 파일에 정의되어 있습니다. 아직 설치하지 않았다면, 프로젝트 루트 디렉토리(`ai_lecture`)에서 다음 명령을 실행하세요.

```bash
pip install -r ../../requirements.txt
```

### 2-1. Python 스크립트 실행

터미널에서 이 디렉토리로 이동한 후 Python 스크립트를 실행합니다:

```bash
cd "ai lecture/source_code/06_machine_learning"
python part_6_machine_learning.py
```

### 2-2. Jupyter 노트북 실행

Jupyter Lab 또는 Jupyter Notebook을 사용하여 인터랙티브하게 실습할 수 있습니다:

```bash
# Jupyter Lab 실행
jupyter lab

# 또는 Jupyter Notebook 실행
jupyter notebook
```
> Jupyter 환경에서 `part_6_machine_learning.ipynb` 파일을 찾아 실행하세요.

## 📚 주요 실습 내용

### 회귀 분석 (Regression)
- 선형 회귀 (Linear Regression)
- 다항 회귀 (Polynomial Regression) 
- 릿지 회귀 (Ridge Regression)
- 회귀 모델 성능 평가: MSE, MAE, R²

### 분류 분석 (Classification)
- 로지스틱 회귀 (Logistic Regression)
- 의사결정 트리 (Decision Tree)
- 랜덤 포레스트 (Random Forest)
- SVM (Support Vector Machine)
- 분류 모델 성능 평가: 정확도, 정밀도, 재현율, F1-Score

### 군집 분석 (Clustering)
- K-Means 클러스터링
- 계층적 클러스터링 (Hierarchical Clustering)
- DBSCAN

### 데이터 전처리 및 모델 평가
- 데이터 정규화 및 표준화
- 훈련/검증/테스트 세트 분할
- 교차 검증 (Cross Validation)
- 그리드 서치를 통한 하이퍼파라미터 튜닝

## 🧪 테스트 실행

이 모듈에는 단위 테스트가 포함되어 있습니다. 테스트를 실행하려면:

```bash
# 프로젝트 루트에서 전체 테스트 실행
bash scripts/run_tests.sh

# 또는 이 모듈의 테스트만 실행
python -m pytest tests/test_part_6.py -v 