# Part 5: AI 핵심 라이브러리 - 실습 코드

이 디렉토리에는 AI 전문가 과정의 **Part 5: AI 핵심 라이브러리**에 해당하는 실습 코드가 포함되어 있습니다.

## 파일 설명

- **`part_5_ai_core_libraries.ipynb`**: 강의 내용과 함께 단계별 코드 실행이 가능한 주피터 노트북 파일입니다. 이론 설명과 코드 예제를 함께 보며 학습하는 데 사용됩니다.
- **`part_5_ai_core_libraries.py`**: `.ipynb` 파일에서 순수 코드 부분만 추출한 파이썬 스크립트입니다. 전체 코드를 한 번에 실행하거나 코드 분석, 테스트 등의 목적으로 사용됩니다.

## 실행 방법

### 주피터 노트북 (`.ipynb`)

1.  이 프로젝트의 가상 환경을 활성화합니다.
2.  터미널에서 `jupyter notebook` 또는 `jupyter lab`을 실행합니다.
3.  웹 브라우저에서 `part_5_ai_core_libraries.ipynb` 파일을 열어 실습을 진행합니다.

### 파이썬 스크립트 (`.py`)
1.  터미널 또는 IDE의 터미널을 엽니다.
2.  이 디렉토리로 이동합니다.
    ```bash
    cd "ai lecture/source_code/05_ai_core_libraries"
    ```
3.  다음 명령어를 사용하여 파이썬 스크립트를 실행합니다.
    ```bash
    python part_5_ai_core_libraries.py
    ```

## 주요 실습 내용

### NumPy

- `np.array()`를 이용한 다차원 배열 생성
- 배열의 형태(shape), 차원(ndim), 데이터 타입(dtype) 확인
- 브로드캐스팅(broadcasting)을 이용한 벡터 연산
- 다양한 집계 함수(`sum`, `mean`, `max` 등) 사용

### Pandas

- `pd.Series` 및 `pd.DataFrame` 생성
- 외부 데이터(CSV) 읽기 및 쓰기
- `iloc`과 `loc`을 이용한 데이터 선택 및 슬라이싱
- 조건 필터링을 이용한 데이터 추출
- `groupby()`를 이용한 데이터 집계
- 누락된 데이터 처리 