# 미적분 시각화 실습 코드

## 🎯 목적

이 디렉토리에는 **시각화와 비유를 중심으로** 미적분의 핵심 개념을 직관적으로 이해할 수 있는 실습 코드가 포함되어 있습니다.

## 📁 파일 구조

```
05.6_calculus_for_ml/
├── README.md                                    # 이 파일
└── linear_regression_gradient_descent.py        # 11개의 시각화 예제
```

## 🚀 실행 방법

### 1. 환경 설정
```bash
pip install numpy matplotlib
```

### 2. 코드 실행
```bash
python linear_regression_gradient_descent.py
```

## 📚 실습 내용

### 1. 미분 시각화 📈
- **파일**: `visualize_derivatives()`
- **목적**: 미분을 "순간 변화율"과 "기울기"로 이해
- **핵심**: 접선의 기울기 = 미분값

### 2. 여러 점에서의 미분 📊
- **파일**: `visualize_multiple_derivatives()`
- **목적**: 함수의 여러 점에서 기울기 변화 관찰
- **핵심**: 미분의 기하학적 의미

### 3. 수치 vs 해석적 미분 🔍
- **파일**: `numerical_vs_analytical_derivatives()`
- **목적**: 두 미분 방법의 비교
- **핵심**: 수치 근사 vs 정확한 해

### 4. 기울기 하강법 🏔️
- **파일**: `gradient_descent_visualization()`
- **목적**: 기울기 하강법을 "산에서 내려오는 사람"으로 이해
- **핵심**: 최적화 과정의 시각화

### 5. 학습률 비교 ⚡
- **파일**: `compare_learning_rates()`
- **목적**: 학습률이 최적화에 미치는 영향
- **핵심**: 적절한 학습률의 중요성

### 6. 편미분 🔧
- **파일**: `partial_derivatives_visualization()`
- **목적**: 편미분을 "여러 변수 중 하나만 바꾸기"로 이해
- **핵심**: 3D 시각화로 다변수 함수 이해

### 7. 그래디언트 벡터 🧭
- **파일**: `gradient_vector_visualization()`
- **목적**: 그래디언트 벡터의 방향과 크기
- **핵심**: 가장 가파르게 증가하는 방향

### 8. 연쇄법칙 🔗
- **파일**: `chain_rule_visualization()`
- **목적**: 연쇄법칙을 "파이프라인을 통해 변화 전파"로 이해
- **핵심**: 합성 함수의 미분

### 9. 신경망 역전파 🧠
- **파일**: `simple_neural_network()`
- **목적**: 간단한 신경망의 역전파 과정
- **핵심**: 딥러닝의 핵심 원리

### 10. 선형 회귀 📊
- **파일**: `linear_regression_gradient_descent()`
- **목적**: 선형 회귀의 경사 하강법 구현
- **핵심**: 실제 머신러닝 모델 학습

### 11. 최적화 알고리즘 비교 🏁
- **파일**: `compare_optimizers()`
- **목적**: 다양한 최적화 알고리즘 비교
- **핵심**: 모멘텀의 효과

## 🎯 학습 팁

### 시각화 중심 학습
- 각 예제를 실행한 후 그래프를 자세히 관찰하세요
- 파라미터를 바꿔보며 결과가 어떻게 변하는지 확인하세요
- 코드의 주석을 읽고 각 단계의 의미를 이해하세요

### 실습 중심 접근
- 코드를 직접 수정해보세요
- 새로운 함수로 테스트해보세요
- 다른 최적화 문제에 적용해보세요

## 🔧 커스터마이징

### 파라미터 조정
```python
# 학습률 조정
learning_rate = 0.05  # 더 작은 학습률

# 함수 변경
def f(x):
    return x**3 + 2*x + 1  # 다른 함수로 테스트
```

### 새로운 예제 추가
```python
def my_custom_optimization():
    """나만의 최적화 함수"""
    # 여기에 코드 작성
    pass
```

## 🎉 핵심 메시지

> **"왜 이걸 배워야 하는가?"** 에 집중합니다.
> 
> 미적분은 머신러닝의 "학습 엔진"입니다. 
> 복잡한 수식보다는 **직관적 이해**와 **실제 구현**에 집중하세요!

## 📖 추가 자료

- [3Blue1Brown - Calculus](https://www.youtube.com/playlist?list=PLZHQObOWTQDMsr9K-rj53DwVRMYO3t5Yr)
- [Khan Academy - Calculus](https://www.khanacademy.org/math/calculus-1)
- [MIT OpenCourseWare - Calculus](https://ocw.mit.edu/courses/mathematics/18-01sc-single-variable-calculus-fall-2010/) 