# 선형대수 시각화 실습 코드

## 🎯 목적

이 디렉토리에는 **시각화와 비유를 중심으로** 선형대수의 핵심 개념을 직관적으로 이해할 수 있는 실습 코드가 포함되어 있습니다.

## 📁 파일 구조

```
05.5_linear_algebra_with_numpy/
├── README.md                                    # 이 파일
└── part_5.5_linear_algebra_with_numpy.py       # 11개의 시각화 예제
```

## 🚀 실행 방법

### 1. 환경 설정
```bash
pip install numpy matplotlib scipy
```

### 2. 코드 실행
```bash
python part_5.5_linear_algebra_with_numpy.py
```

## 📚 실습 내용

### 1. 벡터 시각화 🏹
- **파일**: `visualize_vectors()`
- **목적**: 벡터를 화살표로 시각화하여 방향과 크기 이해
- **핵심**: 벡터 = "방향과 크기를 가진 화살표"

### 2. 벡터 연산 🚶‍♂️
- **파일**: `vector_operations()`
- **목적**: 벡터 덧셈을 "이동 경로 합치기"로 이해
- **핵심**: 벡터 덧셈의 기하학적 의미

### 3. 벡터 유사도 📊
- **파일**: `vector_similarity()`
- **목적**: 내적을 통해 벡터 간 유사도 측정
- **핵심**: 내적 = "서로 얼마나 같은 방향인지"

### 4. 행렬 변환 🎁
- **파일**: `matrix_transformations()`
- **목적**: 행렬을 "데이터 변형기"로 이해
- **핵심**: 회전, 크기 조절, 전단 변환 시각화

### 5. 행렬곱 🔄
- **파일**: `matrix_multiplication()`
- **목적**: 행렬곱을 "복합 변환"으로 이해
- **핵심**: 변환의 순서적 적용

### 6. 고유벡터 🧭
- **파일**: `eigenvectors_visualization()`
- **목적**: 고유벡터를 "변하지 않는 특별한 방향"으로 이해
- **핵심**: 변환 후에도 방향이 유지되는 벡터

### 7. PCA 📈
- **파일**: `pca_visualization()`
- **목적**: PCA를 "데이터의 핵심 방향 찾기"로 이해
- **핵심**: 차원 축소의 직관적 이해

### 8. 이미지 필터링 🖼️
- **파일**: `image_filtering()`
- **목적**: 행렬을 이미지 처리에 활용
- **핵심**: 커널 필터링의 원리

### 9. 추천 시스템 💡
- **파일**: `recommendation_system()`
- **목적**: 행렬 분해를 추천 시스템에 활용
- **핵심**: 사용자-아이템 행렬의 분해

### 10. 벡터 클래스 🛠️
- **파일**: `my_vector_class()`
- **목적**: 나만의 벡터 클래스 구현
- **핵심**: 객체지향 프로그래밍과 벡터

### 11. 신경망 가중치 🧠
- **파일**: `neural_network_weights()`
- **목적**: 신경망 가중치를 행렬로 시각화
- **핵심**: 딥러닝에서의 행렬 활용

## 🎯 학습 팁

### 시각화 중심 학습
- 각 예제를 실행한 후 그래프를 자세히 관찰하세요
- 파라미터를 바꿔보며 결과가 어떻게 변하는지 확인하세요
- 코드의 주석을 읽고 각 단계의 의미를 이해하세요

### 실습 중심 접근
- 코드를 직접 수정해보세요
- 새로운 예제를 추가해보세요
- 다른 데이터셋에 적용해보세요

## 🔧 커스터마이징

### 파라미터 조정
```python
# 벡터 크기 조정
vectors = {
    'v1': np.array([5, 3]),    # 더 큰 벡터
    'v2': np.array([-3, 2]),   # 다른 방향
}

# 학습률 조정
learning_rate = 0.05  # 더 작은 학습률
```

### 새로운 예제 추가
```python
def my_custom_visualization():
    """나만의 시각화 함수"""
    # 여기에 코드 작성
    pass
```

## 🎉 핵심 메시지

> **"왜 이걸 배워야 하는가?"** 에 집중합니다.
> 
> 선형대수는 머신러닝의 "언어"입니다. 
> 복잡한 수식보다는 **직관적 이해**와 **실제 활용**에 집중하세요!

## 📖 추가 자료

- [3Blue1Brown - Essence of Linear Algebra](https://www.youtube.com/playlist?list=PLZHQObOWTQDPD3MizzM2xVFitgF8hE_ab)
- [NumPy 공식 문서](https://numpy.org/doc/)
- [Matplotlib 튜토리얼](https://matplotlib.org/stable/tutorials/index.html) 