# Part 4: 파이썬 객체 지향 프로그래밍 - 실습 코드

이 디렉토리에는 AI 전문가 과정의 **Part 4: 파이썬 객체 지향 프로그래밍(OOP)**에 해당하는 실습 코드가 포함되어 있습니다.

## 파일 설명

- **`part_4_object_oriented_programming.ipynb`**: 강의 내용과 함께 단계별 코드 실행이 가능한 주피터 노트북 파일입니다. 이론 설명과 코드 예제를 함께 보며 학습하는 데 사용됩니다.
- **`part_4_object_oriented_programming.py`**: `.ipynb` 파일에서 순수 코드 부분만 추출한 파이썬 스크립트입니다. 전체 코드를 한 번에 실행하거나 코드 분석, 테스트 등의 목적으로 사용됩니다.

## 실행 방법

### 주피터 노트북 (`.ipynb`)

1.  이 프로젝트의 가상 환경을 활성화합니다.
2.  터미널에서 `jupyter notebook` 또는 `jupyter lab`을 실행합니다.
3.  웹 브라우저에서 `part_4_object_oriented_programming.ipynb` 파일을 열어 실습을 진행합니다.

### 파이썬 스크립트 (`.py`)
1.  터미널 또는 IDE의 터미널을 엽니다.
2.  이 디렉토리로 이동합니다.
    ```bash
    cd "ai lecture/source_code/04_object_oriented_programming"
    ```
3.  다음 명령어를 사용하여 파이썬 스크립트를 실행합니다.
    ```bash
    python part_4_object_oriented_programming.py
    ```

## 주요 실습 내용

- `class` 키워드를 사용한 클래스 정의
- 클래스로부터 객체(인스턴스) 생성 및 사용
- `__init__` 생성자를 이용한 객체 초기화
- 클래스 속성과 인스턴스 속성의 차이 이해
- 다른 클래스의 기능을 물려받는 상속(Inheritance) 구현
- 메서드 오버라이딩(Method Overriding)을 통한 다형성(Polymorphism) 실습 