# Part 3: 파이썬 컬렉션 심화 - 실습 코드

이 디렉토리에는 AI 전문가 과정의 **Part 3: 파이썬 컬렉션 심화**에 해당하는 실습 코드가 포함되어 있습니다.

## 파일 설명

- **`part_3_python_collections.ipynb`**: 강의 내용과 함께 단계별 코드 실행이 가능한 주피터 노트북 파일입니다. 이론 설명과 코드 예제를 함께 보며 학습하는 데 사용됩니다.
- **`part_3_python_collections.py`**: `.ipynb` 파일에서 순수 코드 부분만 추출한 파이썬 스크립트입니다. 전체 코드를 한 번에 실행하거나 코드 분석, 테스트 등의 목적으로 사용됩니다.

## 실행 방법

### 주피터 노트북 (`.ipynb`)

1.  이 프로젝트의 가상 환경을 활성화합니다.
2.  터미널에서 `jupyter notebook` 또는 `jupyter lab`을 실행합니다.
3.  웹 브라우저에서 `part_3_python_collections.ipynb` 파일을 열어 실습을 진행합니다.

### 파이썬 스크립트 (`.py`)
1.  터미널 또는 IDE의 터미널을 엽니다.
2.  이 디렉토리로 이동합니다.
    ```bash
    cd "ai lecture/source_code/03_python_collections"
    ```
3.  다음 명령어를 사용하여 파이썬 스크립트를 실행합니다.
    ```bash
    python part_3_python_collections.py
    ```

## 주요 실습 내용

- `collections.Counter`: 리스트 내 요소들의 빈도수 계산
- `collections.defaultdict`: 키가 없을 때 기본값을 자동으로 생성하여 데이터를 효율적으로 그룹핑
- `collections.deque`: 데이터의 양쪽 끝에서 빠르게 아이템을 추가/제거
- `collections.namedtuple`: 필드에 이름을 부여하여 가독성 높은 튜플 생성 및 사용 