# Part 2 & 3: Python 기본 문법 및 컬렉션 실습

# --- 변수 및 기본 데이터 타입 ---
print("--- 변수 및 기본 데이터 타입 ---")
my_integer = 10
my_float = 3.14
my_string = "Hello, Python!"
my_boolean = True

print(f"정수: {my_integer}, 타입: {type(my_integer)}")
print(f"실수: {my_float}, 타입: {type(my_float)}")
print(f"문자열: {my_string}, 타입: {type(my_string)}")
print(f"불리언: {my_boolean}, 타입: {type(my_boolean)}")
print("-" * 20)


# --- 리스트 (List) ---
print("\n--- 리스트 (List) ---")
my_list = [1, 2, "three", 4.0]
print(f"원본 리스트: {my_list}")

# 요소 추가
my_list.append(5)
print(f"append(5) 후: {my_list}")

# 인덱싱 및 슬라이싱
print(f"첫 번째 요소: {my_list[0]}")
print(f"1번 인덱스부터 3번 인덱스 전까지: {my_list[1:3]}")

# 리스트 컴프리헨션
squares = [x**2 for x in range(5)]
print(f"0-4의 제곱 리스트: {squares}")
print("-" * 20)


# --- 튜플 (Tuple) ---
print("\n--- 튜플 (Tuple) ---")
my_tuple = (1, 2, "three", 4.0)
print(f"튜플: {my_tuple}")
# 튜플은 불변(immutable)이므로 요소 추가/삭제/변경이 불가합니다.
# my_tuple[0] = 99  # TypeError 발생
print(f"튜플의 세 번째 요소: {my_tuple[2]}")
print("-" * 20)


# --- 딕셔너리 (Dictionary) ---
print("\n--- 딕셔너리 (Dictionary) ---")
my_dict = {"name": "Alice", "age": 25, "city": "New York"}
print(f"원본 딕셔너리: {my_dict}")

# 값 접근
print(f"이름: {my_dict['name']}")

# 새로운 키-값 쌍 추가
my_dict["email"] = "alice@example.com"
print(f"이메일 추가 후: {my_dict}")

# 모든 키와 값 순회
print("딕셔너리 키-값:")
for key, value in my_dict.items():
    print(f"  {key}: {value}")
print("-" * 20)


# --- 집합 (Set) ---
print("\n--- 집합 (Set) ---")
my_set = {1, 2, 3, 2, 1}  # 중복된 요소는 자동으로 제거됨
print(f"원본 집합: {my_set}")

# 요소 추가
my_set.add(4)
print(f"add(4) 후: {my_set}")

# 집합 연산
other_set = {3, 4, 5, 6}
print(f"다른 집합: {other_set}")
print(f"합집합: {my_set.union(other_set)}")
print(f"교집합: {my_set.intersection(other_set)}")
print(f"차집합: {my_set.difference(other_set)}")
print("-" * 20)


# --- 제어 흐름 (Control Flow) ---
print("\n--- 제어 흐름 ---")
# if-elif-else
score = 85
if score >= 90:
    grade = "A"
elif score >= 80:
    grade = "B"
else:
    grade = "C"
print(f"점수 {score}점은 {grade} 등급입니다.")

# for 반복문
print("리스트 순회:")
for item in my_list:
    print(f"  - {item}")

# while 반복문
count = 5
print("카운트다운:")
while count > 0:
    print(f"  {count}...")
    count -= 1
print("  발사!")
print("-" * 20)


# --- 함수 (Functions) ---
print("\n--- 함수 ---")


def greet(name):
    """지정된 이름에게 인사하는 함수"""
    return f"안녕하세요, {name}님!"


greeting_message = greet("파이썬")
print(greeting_message)


def calculate_area(width, height):
    """사각형의 넓이를 계산하는 함수"""
    area = width * height
    return area


rectangle_area = calculate_area(10, 5)
print(f"너비 10, 높이 5인 사각형의 넓이는 {rectangle_area}입니다.")
print("-" * 20)
