# AI 강의 유틸리티 스크립트

이 폴더에는 AI 강의 과정에서 사용되는 다양한 유틸리티 스크립트가 포함되어 있습니다.

## 스크립트 목록

- **progress_checker.py**: 학습 진도를 체크하고 관리하는 스크립트
- **format_code.sh**: 코드 스타일을 자동으로 포맷팅하는 스크립트
- **run_tests.sh**: 테스트를 실행하는 스크립트
- **setup.sh**: 개발 환경을 설정하는 스크립트
- **md_to_ipynb_converter.py**: 마크다운 파일을 Jupyter Notebook으로 변환하는 스크립트

## md_to_ipynb_converter.py 사용법

이 스크립트는 마크다운(.md) 파일을 Jupyter Notebook(.ipynb) 형식으로 변환합니다.

### 기능

- 마크다운 내의 코드 블록을 Jupyter Notebook의 코드 셀로 변환
- 일반 텍스트는 마크다운 셀로 변환
- 여러 디렉토리를 한 번에 처리 가능

### 사용 방법

```bash
# courses 디렉토리 내의 모든 마크다운 파일 변환
python3 md_to_ipynb_converter.py --courses

# tutorials 디렉토리 내의 모든 마크다운 파일 변환
python3 md_to_ipynb_converter.py --tutorials

# 특정 디렉토리의 마크다운 파일 변환
python3 md_to_ipynb_converter.py --dir /path/to/directory
```

### 예시

```bash
# 프로젝트 루트 디렉토리에서 실행
python3 2_services/ai_lecture/scripts/md_to_ipynb_converter.py --tutorials

# 스크립트가 있는 디렉토리에서 실행
cd 2_services/ai_lecture/scripts
python3 md_to_ipynb_converter.py --courses
```

---

[↩️ 전체 커리큘럼으로 돌아가기](../README.md) 