# AI 강의 튜토리얼 자료

이 폴더에는 AI 강의에서 사용되는 다양한 튜토리얼 자료가 포함되어 있습니다.

## 폴더 구조

- **numpy-pandas/**: NumPy와 Pandas 라이브러리를 학습하기 위한 튜토리얼
  - 마크다운(.md) 및 Jupyter Notebook(.ipynb) 형식으로 제공
  - 기초부터 실전 데이터 분석까지 단계별 학습 가능

## 튜토리얼 사용 방법

### Jupyter Notebook 실행

```bash
# 가상환경 활성화
source ../../../venv/bin/activate

# Jupyter Notebook 실행
jupyter notebook
```

### 마크다운 파일을 Jupyter Notebook으로 변환

새로운 마크다운 파일을 추가한 후, 다음 명령어를 사용하여 Jupyter Notebook으로 변환할 수 있습니다:

```bash
# 프로젝트 루트 디렉토리에서 실행
python3 2_services/ai_lecture/scripts/md_to_ipynb_converter.py --tutorials
```

## NumPy & Pandas 튜토리얼 개요

### 1. 순차적 학습 (권장)
1. `01_numpy_basic_arrays.ipynb` - NumPy 기초 배열 생성
2. `02_numpy_indexing_slicing.ipynb` - NumPy 인덱싱과 슬라이싱
3. `03_pandas_series_basics.ipynb` - Pandas Series 기초
4. `04_pandas_dataframe_basics.ipynb` - Pandas DataFrame 기초
5. `05_data_analysis_titanic.ipynb` - 실전 데이터 분석

### 2. 난이도별 학습
- **초급**: 01, 03, 04번 파일
- **중급**: 02, 05번 파일
- **고급**: 전체 파일 + 추가 연습문제

---

[↩️ 전체 커리큘럼으로 돌아가기](../../README.md) 