# 파이썬 기초 연습 문제

## Part 1: 변수와 자료형

### 문제 1: 변수 선언 및 출력
- **요구사항:** 이름(`name`)과 나이(`age`)를 저장하는 변수를 각각 선언하고, "제 이름은 [이름]이고, 나이는 [나이]살입니다." 형식으로 출력하는 코드를 작성하세요.

### 문제 2: 자료형 확인
- **요구사항:** 다음 변수들의 자료형을 확인하고 출력하는 코드를 작성하세요.
  - `num = 10`
  - `pi = 3.14`
  - `message = "안녕하세요"`
  - `is_true = True`

### 문제 3: 형 변환 (Casting)
- **요구사항:** 사용자로부터 문자열 형태로 숫자를 입력받아 정수형으로 변환한 후, 그 숫자에 10을 더한 결과를 출력하는 코드를 작성하세요. (`input()` 함수 사용)

### 문제 4: 문자열 인덱싱
- **요구사항:** `major = "AI Engineering"` 이라는 문자열에서, "AI"만 추출하여 출력하는 코드를 작성하세요.

### 문제 5: 리스트 다루기
- **요구사항:** 좋아하는 과일 3개를 담은 리스트 `fruits`를 만들고, 두 번째 과일을 출력한 후, 마지막에 새로운 과일 "딸기"를 추가하고 리스트 전체를 출력하는 코드를 작성하세요.

## Part 2: 제어문 (if, for, while)

### 문제 6: if-elif-else 조건문
- **요구사항:** 사용자로부터 점수를 입력받아, 90점 이상이면 "A", 80점 이상이면 "B", 70점 이상이면 "C", 그 외에는 "F"를 출력하는 코드를 작성하세요.

### 문제 7: for 반복문과 리스트
- **요구사항:** `numbers = [1, 2, 3, 4, 5]` 리스트의 모든 요소를 하나씩 출력하는 코드를 `for`문을 사용하여 작성하세요.

### 문제 8: for 반복문과 range()
- **요구사항:** `for`문과 `range()` 함수를 사용하여 1부터 10까지의 숫자 중 짝수만 출력하는 코드를 작성하세요. (힌트: `if` 조건문을 함께 사용)

### 문제 9: while 반복문
- **요구사항:** `while`문을 사용하여 1부터 100까지의 모든 숫자의 합을 구하고 출력하는 코드를 작성하세요.

### 문제 10: 반복문 제어 (break)
- **요구사항:** `while True` 무한 루프 안에서 사용자에게 계속해서 입력을 받다가, 사용자가 "exit"를 입력하면 루프를 빠져나오는 코드를 작성하세요. 

## Part 3: 함수와 라이브러리 활용

### 문제 11: 리스트에서 짝수만 필터링하기
- **설명:** 주어진 숫자 리스트에서 짝수만 골라 새로운 리스트를 만들어 반환하는 함수 `filter_even_numbers`를 작성하세요.
- **요구사항:**
  - 함수 이름은 `filter_even_numbers`여야 합니다.
  - 리스트 내포(list comprehension)를 사용하여 한 줄로 작성해보세요.
- **예시:**
  ```python
  input_list = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
  output_list = filter_even_numbers(input_list)
  print(output_list)  # 결과: [2, 4, 6, 8, 10]
  ```

### 문제 12: 단어 빈도수 세기
- **설명:** 주어진 문장에서 각 단어의 빈도수를 계산하여 딕셔너리 형태로 반환하는 함수 `count_word_frequency`를 작성하세요.
- **요구사항:**
  - 함수 이름은 `count_word_frequency`여야 합니다.
  - 문장은 공백으로 단어가 구분됩니다.
  - 대소문자는 구분하지 않습니다 (모두 소문자로 변환하여 계산).
- **예시:**
  ```python
  sentence = "apple banana apple orange banana apple"
  frequency_dict = count_word_frequency(sentence)
  print(frequency_dict)  # 결과: {'apple': 3, 'banana': 2, 'orange': 1}
  ```

### 문제 13: 간단한 계산기 함수 만들기
- **설명:** 두 숫자와 연산자(문자열)를 인자로 받아 사칙연산(+, -, *, /)을 수행하는 함수 `simple_calculator`를 작성하세요.
- **요구사항:**
  - 함수 이름은 `simple_calculator`여야 합니다.
  - `+`, `-`, `*`, `/` 외의 연산자가 들어오면 "지원하지 않는 연산자입니다." 라는 메시지를 반환하세요.
  - 0으로 나누는 경우, "0으로 나눌 수 없습니다." 라는 메시지를 반환하세요.
- **예시:**
  ```python
  result1 = simple_calculator(10, 5, '+')
  print(result1)  # 결과: 15

  result2 = simple_calculator(10, 5, '/')
  print(result2) # 결과: 2.0
  ```

### 문제 14: Numpy를 이용한 벡터의 내적 계산
- **설명:** Numpy 라이브러리를 사용하여 두 벡터(1차원 배열)의 내적을 계산하는 함수 `calculate_dot_product`를 작성하세요.
- **요구사항:**
  - 함수 이름은 `calculate_dot_product`여야 합니다.
  - `numpy.dot()` 함수를 사용하세요.
- **예시:**
  ```python
  import numpy as np

  vector1 = np.array([1, 2, 3])
  vector2 = np.array([4, 5, 6])
  dot_product = calculate_dot_product(vector1, vector2)
  print(dot_product)  # 결과: 32
  ```

### 문제 15: Pandas DataFrame 생성 및 특정 조건 데이터 선택
- **설명:** 주어진 데이터를 사용하여 Pandas DataFrame을 생성하고, '나이(Age)'가 30 이상인 사람들의 '이름(Name)'을 선택하여 리스트로 반환하는 함수 `select_people_over_30`를 작성하세요.
- **요구사항:**
  - 함수 이름은 `select_people_over_30`여야 합니다.
  - Pandas의 boolean indexing을 사용하세요.
- **데이터:**
  ```python
  data = {
      'Name': ['Alice', 'Bob', 'Charlie', 'David', 'Eve'],
      'Age': [25, 32, 28, 45, 31],
      'City': ['New York', 'Paris', 'London', 'Tokyo', 'Seoul']
  }
  ```
- **예시:**
  ```python
  import pandas as pd

  df = pd.DataFrame(data)
  names = select_people_over_30(df)
  print(names) # 결과: ['Bob', 'David', 'Eve']
  ``` 